import argparse
import os

from crypta.graph.sampling.lib import RandomSampler, StaffSampler


RANDOM_MODE = "random"
STAFF_MODE = "staff"


def arg_parse():
    argparser = argparse.ArgumentParser()
    argparser.add_argument("--components_table", type=str, required=True)
    argparser.add_argument("--mode", choices=[RANDOM_MODE, STAFF_MODE], default=RANDOM_MODE, required=True)
    argparser.add_argument("--percent", type=float, default=0.1, help="Float number it is proportion of sample")
    argparser.add_argument("--output-edges", type=str)
    argparser.add_argument("--output-properties", type=str)
    argparser.add_argument("--yt-proxy", type=str, default=None)
    argparser.add_argument("--yt-pool", type=str, default="crypta")

    return argparser.parse_args()


def main():
    args = arg_parse()

    if not args.yt_proxy:
        args.yt_proxy = os.environ.get("YT_PROXY")

    if args.mode == RANDOM_MODE:
        sampler = RandomSampler(
            args.components_table,
            args.percent,
            args.output_edges,
            args.output_properties,
            args.yt_proxy,
            args.yt_pool
        )
    elif args.mode == STAFF_MODE:
        sampler = StaffSampler(
            args.components_table,
            args.output_edges,
            args.output_properties,
            args.yt_proxy,
            args.yt_pool
        )
    else:
        raise Exception('Mode "{mode}" is not known'.format(mode=args.mode))

    sampler.run()


if __name__ == "__main__":
    main()
