# coding: utf-8
from ads.bsyeti.tools.solomon.lib.source_urls import gen_dashboard_autogen_line
from ads.bsyeti.tools.solomon.dashboards.lib.generator import DashboardGenerator

from crypta.graph.solomon.dashboards import menu_utils

import urllib.parse

MTR_ARR, EXT_ARR = menu_utils.MTR_ARR, menu_utils.EXT_ARR
PROJECT = menu_utils.PROJECT
SERVICE = "Herschel"

DC_LIST = ("Sas", "Vla", "Man", "Iva")
MENU_ITEM_TITLE = "Herschel {0}".format(MTR_ARR)
STANDS = ("prod",)  # "test")
PATH_SUFFIX = {"prod": "production", "test": "testing"}

dashboardGenerator = DashboardGenerator(
    project=PROJECT,
    magic_prefix_map={
        "Z": "",
        "H": "l.host={{host}}&",
        "T": "l.src_topic={{src_topic}}&",
        "D": "l.src_dc={{src_dc}}&",
        "G": "l.graph={{graph}}&",
        "Y": "cluster={{yt_cluster}}&",
        "S": "l.system={{system}}&",
    },
)
item, row, make_grid = (
    dashboardGenerator.item,
    dashboardGenerator.row,
    dashboardGenerator.make_grid,
)

STATE_TABLES = {
    "prod": "//home/crypta/production/rtsklejka/state/herschel_state",
    "test": "//home/crypta/testing/rtsklejka/state/herschel_state",
}

QUEUES = [
    ("herschel", "//home/crypta/{suffix}/rtsklejka/qyt/sharded_fprints"),
]


def gen_storage_usage(stand="test"):
    return {
        "id": "yt_storage_usage_herschel_{}".format(stand),
        "projectId": PROJECT,
        "name": "Herschel Storage Usage ({})".format(stand),
        "description": gen_dashboard_autogen_line(),
        "heightMultiplier": 1,
        "parameters": [
            {"name": "yt_cluster", "value": "*"},
        ],
        "rows": [
            row(
                item(
                    "Space Usage: " + stand,
                    "",
                    (
                        "Y#project=yt&service=table_statistics_monitor&sensor=table_statistics.resource_usage.disk_space"
                        "&graph=auto&l.path={path}&stack=false"
                    ).format(path=STATE_TABLES[stand]),
                ),
                item(
                    "Write bytes/s: " + stand,
                    "",
                    (
                        "Y#project=yt&service=yt_node_tablet_profiling|node_tablet&tablet_id=-&table_tag=-&host=Aggr&sensor=yt.tablet_node.write.data_weight.rate"
                        "&cell_id=-&graph=auto&l.table_path={path}&"
                        "l.tablet_cell_bundle=-&l.user=-&stack=false"
                    ).format(path=STATE_TABLES[stand]),
                ),
            ),
        ],
    }


def gen_queues_dashboard(stand="test"):
    rows = []
    project = "big_rt_queue_daemon"

    for consumer, queue in QUEUES:
        name = consumer.split("_", 1)[-1].capitalize()
        path = queue.format(suffix=PATH_SUFFIX[stand])
        rows.append(
            row(
                item(
                    f"{name} queue write rate",
                    "",
                    f"?project={project}&&queue={path}&l.consumer=ideal_consumer&l.sensor=row_rate&l.shard=-&min=0&downsamplingFill=previous&graph=auto",
                ),
                item(
                    f"{name} queue read rate",
                    "",
                    f"?project={project}&queue={path}&consumer={consumer}&l.sensor=row_rate&l.shard=-&min=0&downsamplingFill=previous&graph=auto",
                ),
                item(
                    f"{name} lag",
                    "",
                    f"?project={project}&queue={path}&consumer={consumer}&&l.sensor=row_lag&l.shard=-&stack=false&min=0&downsamplingFill=previous&graph=auto",
                ),
                item(
                    f"{name} queue stored rows",
                    "",
                    f"?project={project}&queue={path}&sensor=existing_rows&shard=-&min=0&downsamplingFill=previous&graph=auto",
                ),
            )
        )
    return {
        "id": "herschel_queues_{}".format(stand),
        "projectId": PROJECT,
        "name": "Herschel {} queues".format(stand),
        "description": gen_dashboard_autogen_line(),
        "heightMultiplier": 1,
        "parameters": [],
        "rows": rows,
    }


def gen_load_dashboard():
    return {
        "id": "herschel_load",
        "projectId": PROJECT,
        "name": "Herschel load",
        "description": gen_dashboard_autogen_line(),
        "heightMultiplier": 1,
        "parameters": [
            {"name": "host", "value": "cluster"},
            {"name": "graph", "value": "*"},
            {"name": "cluster", "value": "*"},
            {"name": "service", "value": "*"},
            {"name": "system", "value": "herschel"},
        ],
        "rows": [
            row(
                item(
                    "Young consuming systems",
                    "",
                    "HGDS#sensor=bigrt.cs.balancer_young|bigrt.cs.system_young&min=0",
                ),
                item(
                    "Young mediators",
                    "",
                    "HGDS#sensor=bigrt.cs.mediator_iteration_young|bigrt.cs.mediator_young&min=0",
                ),
                item(
                    "Current shards",
                    "",
                    "HGDS#sensor=bigrt.cs.current_shards",
                ),
                item(
                    "Commits",
                    "",
                    "HGDS#sensor=commits_*&place=stateful_processor&stack=false&min=0",
                ),
            ),
            row(
                item(
                    "Input messages",
                    "",
                    "HGDS#sensor=bigrt.cs.messages_total&supplier=*",
                ),
                item(
                    "Processed bytes",
                    "",
                    "HGDS#place=stateful_processor&sensor=processed_bytes",
                ),
                item(
                    "States size quota % usage herschel states",
                    "",
                    "HGDS#l.sensor=states_size_quota_usage_percents&stack=false&norm=true",
                ),
                item(
                    "Commit timings",
                    "",
                    "HGDS#sensor=*&place=stateful_processor&subplace=commit_detailed",
                ),
            ),
            row(
                item(
                    "Wait for data",
                    "",
                    "HGDS#place=stateful_processor&sensor=wait_for_*_total_time",
                ),
                item(
                    "Messages",
                    "",
                    "HGDS#sensor=bigrt.cs.messages_*&supplier=*&stack=false&min=0",
                ),
                item(
                    "From epoch begin to epoch commited",
                    "",
                    "HGDS#&place=stateful_processor&l.subplace=-&l.sensor=epoch_from_begin_to_commited&norm=true&stack=false&l.shard=-",
                ),
                item(
                    "Pure commit timings distribution",
                    "",
                    "HGDS#&place=stateful_processor&l.subplace=-&l.sensor=commit_time&norm=true&stack=false&l.shard=-",
                ),
            ),
            row(
                item(
                    "Memory Load",
                    "",
                    "HGD#sensor=yt.resource_tracker.memory_usage.rss&stack=true&min=0",
                ),
                item(
                    "CPU Usage",
                    "",
                    "HGD#sensor=yt.resource_tracker.*cpu&l.thread=-&stack=true&min=0",
                ),
                item(
                    "Inflight",
                    "",
                    "HSTD#sensor=bigrt.inflight_limiter.bytes&stack=false&min=0",
                ),
                item(
                    "Trottle time",
                    "",
                    "HSTD#place=reshard_batches&sensor=*trottle_total_time&shard=-&stack=false&min=0",
                ),
            ),
            row(
                item(
                    "Versions",
                    "",
                    "#host=*&checks=-cluster;{skip}&sensor=revision&hideNoData=true"
                    "&stack=false&numberFormat=0|".format(skip=";".join(DC_LIST)),
                ),
                item(
                    "Build Time",
                    "",
                    "#host=*&checks=-cluster;{skip}&sensor=build_time&hideNoData=true"
                    "&stack=false&numberFormat=0|".format(skip=";".join(DC_LIST)),
                ),
                item(
                    "Vulture Manager",
                    "",
                    "HGTD#place=vulture_manager&system=vulture&sensor=*&min=0&stack=false",
                ),
            ),
            row(
                item(
                    "Ban/unban counter",
                    "",
                    "HGTD#place=herschel_processor&sensor=*banned_fps&stack=true&min=0",
                ),
                item(
                    "New ids over ban frame",
                    "",
                    "HGTD#place=herschel_processor&sensor=ban_counter_hist&stack=true&min=0",
                ),
                item(
                    "Queue message processing lag",
                    "",
                    "HGTD#place=herschel_processor&sensor=event_lag_hist&stack=true&min=0",
                ),
            ),
        ],
    }


def generate_dashboards():
    return [
        gen_load_dashboard(),
        gen_queues_dashboard(stand="prod"),
        gen_queues_dashboard(stand="test"),
        gen_storage_usage(stand="prod"),
        gen_storage_usage(stand="test"),
    ]


def generate_dashboard_info(stand="test"):
    load_url_template = (
        "/"
        "?project={project}"
        "&cluster=herschel-{stand}"
        "&service=herschel-{stand}"
        "&dashboard=herschel_load"
        "&l.host=cluster"
        "&src_topic=*"
        "&src_dc=*"
        "&system=herschel"
        "&b=1h30m"
    )
    storage_url_template = (
        "/"
        "?project={project}"
        "&yt_cluster=*"
        "&dashboard=yt_storage_usage_herschel_{stand}"
        "&b=1d"
    )
    queues_url_template = (
        "/" "?project={project}" "&dashboard=herschel_queues_{stand}" "&b=1d"
    )

    infos = [
        {
            "name": "{service} {stand} load".format(service=SERVICE, stand=stand),
            "group": "Load",
            "important": True,
            "url": load_url_template.format(project=PROJECT, stand=stand),
        },
        {
            "name": "{service} {stand} storage".format(service=SERVICE, stand=stand),
            "group": "Load",
            "important": True,
            "url": storage_url_template.format(project=PROJECT, stand=stand),
        },
        {
            "name": "{service} {stand} queues".format(service=SERVICE, stand=stand),
            "group": "Queue",
            "important": True,
            "url": queues_url_template.format(project=PROJECT, stand=stand),
        },
    ]

    return infos


def generate_menu_items():
    items = menu_utils.top_level_template()

    for stand in STANDS:
        for info in generate_dashboard_info(stand=stand):
            if info["group"] in items:
                items[info["group"]].append(
                    {
                        "title": info["name"],
                        "url": info["url"],
                    }
                )

    for stand in STANDS:
        items["Deploy"].append(
            {
                "title": "{service} {stand} {ext}".format(
                    service=SERVICE, stand=stand, ext=EXT_ARR
                ),
                # "url": "https://deploy.yandex-team.ru/stage/crypta-rtfp-herschel-{stand}".format(stand=stand),
                "url": "https://deploy.yandex-team.ru/stage/crypta-rtfp-herschel",
            }
        )

    queue_cluster = {"prod": "arnold", "test": "hahn"}
    for stand in STANDS:
        for consumer, queue in QUEUES:
            name = consumer.split("_", 1)[-1].capitalize()
            items["Queue"].append(
                {
                    "title": "{} {} queue".format(name, stand),
                    "url": (
                        "/"
                        "?project=big_rt_queue_daemon"
                        "&cluster={cluster}"
                        "&consumer={consumer}"
                        "&queue={queue}"
                        "&dashboard=queue_lags_and_rate"
                    ).format(
                        consumer=consumer,
                        queue=urllib.parse.quote_plus(
                            queue.format(suffix=PATH_SUFFIX[stand])
                        ),
                        cluster=queue_cluster[stand],
                    ),
                }
            )

    return items
