# coding: utf-8
MTR_ARR = u"▾"
EXT_ARR = u"↗"

PROJECT = "crypta_graph"

TOP_LEVEL_MENU = [
    "Info",
    "Load",
    "Identification",
    "Lag",
    "Written",
    "LB Consumers",
    "Queue",
    "Deploy",
    "YT",
]


def top_level_template():
    return {name: [] for name in TOP_LEVEL_MENU}


def _items(menu, root_items):
    menu_items = [
        {"title": u"{} {}".format(name, MTR_ARR), "children": menu[name]}
        for name in TOP_LEVEL_MENU
    ]

    root_children = [
        {
            "title": root_item["title"],
            "children": [
                {
                    "title": u"{} {}".format(name, MTR_ARR),
                    "children": root_item["items"][name],
                }
                for name in TOP_LEVEL_MENU
                if root_item["items"].get(name)
            ],
        }
        for root_item in root_items
    ]

    return [
        {
            "title": u"Crypta Graph {}".format(MTR_ARR),
            "children": root_children,
        }
    ] + menu_items


def generate_menu(menu, root_items):
    return {"items": _items(menu, root_items), "projectId": PROJECT}
