import os
import argparse

from crypta.lib.python.yql_runner.base_parser import BaseParser


class SoupAttributesYqlQuery(BaseParser):
    QUERY_TEMPLATE = 'query.sql.j2'

    def __init__(self,
                 components_table,
                 attributes_table,
                 vertices_properties_table,
                 components_properties_table,
                 date, pool, yt_proxy):
        self.date = date
        self.pool = pool
        self.yt_proxy = yt_proxy

        self.components_table = components_table
        self.attributes_table = attributes_table
        self.vertices_properties_table = vertices_properties_table
        self.components_properties_table = components_properties_table

        super(SoupAttributesYqlQuery, self).__init__(
            date=date,
            yt_proxy=yt_proxy,
            pool=pool,
            is_embedded=False
        )

    def get_dirs(self):
        dirs = super(SoupAttributesYqlQuery, self).get_dirs()
        dirs.update(
            components_table=self.components_table,
            attributes_table=self.attributes_table,
            vertices_properties_table=self.vertices_properties_table,
            components_properties_table=self.components_properties_table
        )
        return dirs


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--date', help='Run script for the specified date (yyyy-mm-dd)')
    return parser.parse_args()


def main():
    # tmp

    args = parse_args()
    date = args.date

    yt_proxy = os.environ.get('YT_PROXY')
    env = os.environ.get('ENVIRONMENT')
    pool = os.environ.get('YT_POOL', 'crypta_graph')

    assert os.environ.get('YQL_TOKEN'), 'need yql token'
    assert os.environ.get('YT_TOKEN'), 'need yt token'

    components_table = '//home/crypta/production/state/graph/v2/soup_cc/components'
    components_properties_table = '//home/crypta/production/state/graph/v2/soup_cc/workdir/Sources/BVMins'

    vertices_properties_table = '//home/crypta/{}/state/graph/v2/soup/cooked/vertices_properties'.format(env)
    attributes_table = '//home/crypta/{}/state/graph/v2/soup/attributes'.format(env)
    yql = SoupAttributesYqlQuery(
        components_table=components_table,
        attributes_table=attributes_table,
        vertices_properties_table=vertices_properties_table,
        components_properties_table=components_properties_table,
        date=date,
        pool=pool,
        yt_proxy=yt_proxy
    )
    yql.run()
