use hahn;
pragma yt.InferSchema;

$cc = '{{components_table}}';
$vertices_properties = '{{vertices_properties_table}}';
$components_properties = '{{components_properties_table}}';
$attributes_table = '{{attributes_table}}';

$cc = (
    select cc.component_id as component_id, cc.id as id
    from $cc as cc
    left only join $components_properties as props
    on cc.component_id == props.v
);

$vertices_properties = (
    select *
    from `//home/crypta/production/state/graph/v2/soup/cooked/vertices_properties`
);

$components_active_yuids_number = (
    select
        cc.component_id as component_id,
        count_if(vp.is_active == True) as active_yuids_number
    from $cc as cc
    join $vertices_properties as vp
    on cc.id = vp.id
    where vp.id_type = 'yandexuid'
    group by cc.component_id
);

$components_with_active_yuids = (
    select component_id,
        active_yuids_number != 0 as has_active_yandexuid
    from $components_active_yuids_number
);

select * from $components_with_active_yuids;

--------------------------------------------------------------------------------

$components_active_devices_number = (
    select
        cc.component_id as component_id,
        count_if(vp.is_active == True) as active_devices_number
    from $cc as cc
    join $vertices_properties as vp
    on cc.id = vp.id
    where vp.id_type = 'idfa' or vp.id_type = 'gaid' or vp.id_type = 'mm_device_id'
    group by cc.component_id
);

$components_with_active_devices = (
    select component_id,
        active_devices_number != 0 as has_active_devices
    from $components_active_devices_number
);

select * from $components_with_active_devices;

--------------------------------------------------------------------------------

$components_user_profile = (
    select
        cc.component_id as component_id,
        true as has_user_profile
    from $cc as cc
    join $vertices_properties as vp
    on cc.id = vp.id
    where
        vp.ageSegments is not Null or
        vp.year_of_birth is not Null or

        vp.gender is not Null or
        vp.genderSegments is not Null or

        vp.socdem_source is not Null

    group by cc.component_id
);

select * from $components_user_profile;

$agg_info = (
    select
        cc.component_id as component_id,
        count_if(act_yuids.has_active_yandexuid is not Null) as active_yandexuid_count,
        count_if(act_devices.has_active_devices is not Null) as active_devices_count,
        count_if(user_profile.has_user_profile is not Null) as user_profile_count
    from $cc as cc
    left join $components_with_active_yuids as act_yuids
    on cc.component_id = act_yuids.component_id
    left join $components_with_active_devices as act_devices
    on cc.component_id = act_devices.component_id
    left join $components_user_profile as user_profile
    on cc.component_id = user_profile.component_id
    group by cc.component_id
);

insert into $attributes_table
with truncate
select
    component_id,
    if(active_yandexuid_count = 0, False, True) as has_active_yandexuid,
    if(active_devices_count = 0, False, True) as has_active_devices,
    if(user_profile_count = 0, False, True) as has_user_profile
from $agg_info;
