#pragma once

#include <crypta/graph/soup/config/proto/edge_type.pb.h>
#include <crypta/lib/proto/identifiers/id_type.pb.h>
#include <crypta/graph/soup/config/proto/log_source.pb.h>
#include <crypta/graph/soup/config/proto/source_type.pb.h>

#include <util/generic/vector.h>

namespace NCrypta {
    namespace NSoup {
        using NCrypta::NIdentifiersProto::NIdType::EIdType;
        using NCrypta::NIdentifiersProto::NIdType::TIdType;
        using NCrypta::NIdentifiersProto::NRepObj::ERepresentedObjectType;
        using NSourceType::ESourceType;
        using NSourceType::TSourceType;
        using NLogSource::ELogSourceType;
        using NLogSource::TLogSourceType;

        const TVector<TEdgeType>& EdgeTypes();
        const TVector<TEdgeRecord>& EdgeRecords();

        const TEdgeType& EdgeType(const EIdType, const EIdType, const ESourceType, const ELogSourceType);
        const TEdgeType& EdgeType(const TStringBuf, const TStringBuf, const TStringBuf, const TStringBuf);

        const TEdgeProps& EdgeProps(const TEdgeType&);
        const TEdgeUsage& EdgeUsage(const TEdgeType&);

        const TIdType& IdType(const EIdType);
        const TIdType& IdType(const TStringBuf);

        const TSourceType& SourceType(const ESourceType);
        const TSourceType& SourceType(const TStringBuf);

        const TLogSourceType& LogSourceType(const ELogSourceType);
        const TLogSourceType& LogSourceType(const TStringBuf);
    }
}
