from collections import namedtuple, defaultdict
from crypta.graph.soup.config.python import ID_TYPE, EDGE_TYPE


Visitor = namedtuple('Visitor', 'current_id_type path')


def find_paths(edges, target_id_type, visitor, result):
    if visitor.current_id_type == target_id_type.Type:
        result.append(visitor.path)
    else:
        for idt in edges[visitor.current_id_type]:
            if idt not in visitor.path:
                new_visitor = Visitor(idt, visitor.path + [idt])
                find_paths(edges, target_id_type, new_visitor, result)


def search(start_id_type, target_id_type, edges):
    '''
        Поиск всевозможных путей из start_id_type в target_id_type, DFS
    '''
    initial = Visitor(start_id_type.Type, [start_id_type.Type])
    result = []
    find_paths(edges, target_id_type, initial, result)
    return result


def main():
    start_id_type = ID_TYPE.YANDEXUID
    target_id_type = ID_TYPE.MM_DEVICE_ID

    edges = defaultdict(lambda: defaultdict(list))
    for et in EDGE_TYPE.values():
        if not et.SourceType.Name.startswith('partner_'):
            edges[et.Id1Type.Type][et.Id2Type.Type].append(et)
            edges[et.Id2Type.Type][et.Id1Type.Type].append(et)

    # Печатает все последовательности типов идентификаторов для склейки start_id_type и target_id_type
    paths = search(start_id_type, target_id_type, edges)
    for path in paths:
        print [ID_TYPE.by_type(x).Name for x in path]

    print '--------------'
    print ''

    # Печатает последовательность типов рёбер для первого варианта из ^^^
    for id1_type, id2_type in zip(paths[0], paths[0][1:]):
        print ', '.join([EDGE_TYPE.name(et) for et in edges[id1_type][id2_type]])
