package ru.yandex.crypta.graph.soup.config;

public class NoSuchEdgeException extends RuntimeException {

    private String id1Type;
    private String id2Type;
    private String sourceType;
    private String logSource;

    public NoSuchEdgeException(String id1Type, String id2Type, String sourceType, String logSource) {
        super("Edge doesn't exist: id1Type = " + id1Type + ", id2Type = " +
            id2Type + ", sourceType = " + sourceType + ", logSource = " + logSource);
        this.id1Type = id1Type;
        this.id2Type = id2Type;
        this.sourceType = sourceType;
        this.logSource = logSource;
    }

    public String getId1Type() {
        return id1Type;
    }

    public String getId2Type() {
        return id2Type;
    }

    public String getSourceType() {
        return sourceType;
    }

    public String getLogSource() {
        return logSource;
    }
}
