package ru.yandex.crypta.graph.soup.config;

import org.junit.Test;

import ru.yandex.crypta.graph.soup.config.proto.ELogSourceType;
import ru.yandex.crypta.graph.soup.config.proto.ESourceType;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeProps;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeType;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeUsage;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

public class SoupConfigTest {

    @Test
    public void testInit() {
        assertFalse(Soup.CONFIG.getEdgeTypes().isEmpty());
    }

    @Test
    public void testEnums() {
        assertEquals("yandexuid", Soup.CONFIG.name(EIdType.YANDEXUID));
        assertEquals("app-url-redir", Soup.CONFIG.name(ESourceType.APP_URL_REDIR));
        assertEquals("fp", Soup.CONFIG.name(ELogSourceType.FINGERPRINTS));

        assertEquals(ELogSourceType.WATCH_LOG, Soup.CONFIG.getLogSource("wl").getType());
    }

    @Test
    public void testEdgePropsMd5() {
        // Should check is email-md5 is correct edge
        TEdgeType et = TEdgeType.newBuilder()
            .setId1Type(EIdType.EMAIL)
            .setId2Type(EIdType.EMAIL_MD5)
            .setSourceType(ESourceType.MD5_HASH)
            .setLogSource(ELogSourceType.SOUP_PREPROCESSING)
            .build();

        assertEquals(TEdgeProps.EEdgeStrength.ARTIFICIAL, Soup.CONFIG.getEdgeProps(et).getEdgeStrength());
    }

    @Test
    public void testEdgePropsSha256() {
        // Should check is email-sha256 is correct edge
        TEdgeType et = TEdgeType.newBuilder()
            .setId1Type(EIdType.EMAIL)
            .setId2Type(EIdType.EMAIL_SHA256)
            .setSourceType(ESourceType.SHA256_HASH)
            .setLogSource(ELogSourceType.SOUP_PREPROCESSING)
            .build();

        assertEquals(TEdgeProps.EEdgeStrength.ARTIFICIAL, Soup.CONFIG.getEdgeProps(et).getEdgeStrength());
    }

    @Test
    public void testEdgeUsage() {
        TEdgeType et = TEdgeType.newBuilder()
            .setId1Type(EIdType.YANDEXUID)
            .setId2Type(EIdType.UUID)
            .setSourceType(ESourceType.SEARCH_APP_MOB_REPORT)
            .setLogSource(ELogSourceType.MOBILE_REPORT_LOG)
            .build();
        TEdgeUsage usage = Soup.CONFIG.getEdgeUsage(et);
        assertFalse(usage.getSoupUpdate());
        assertTrue(usage.getYandexSafe());
        assertTrue(usage.getHumanMatching());
        assertTrue(usage.getSoupyIndevice());
    }
}
