import os
import argparse
import datetime

from crypta.lib.python.yql_runner.base_parser import BaseParser


class IcookieDict(BaseParser):

    """ Create yuid - icookie dicts from soup """

    QUERY_TEMPLATE = 'query.sql.j2'

    def get_libs(self):
        return []


def main():
    yesterday = (datetime.datetime.now() - datetime.timedelta(days=1)).strftime('%Y-%m-%d')
    argparser = argparse.ArgumentParser()
    argparser.add_argument('--date', type=str, default=yesterday)
    args = argparser.parse_args()

    task = IcookieDict(
        date=args.date,
        yt_proxy=os.getenv('YT_PROXY'),
        pool='crypta_graph',
        crypta_env=os.getenv('ENVIRONMENT'),
        is_embedded=False,
    )
    task.run()


if __name__ == '__main__':
    main()
