$date = '{{ date }}';

$TPF_BUFF = 50;
$INTERVAL = DateTime::IntervalFromDays(35);
$min_active_date = CAST(CAST($date AS Date) - $INTERVAL AS String);

$prefix = '{{ graph_output_dir }}';
$soup_table = $prefix || '/v2/soup/yandexuid_icookie_cookie_wl';
$yuid_icookie = $prefix || '/dicts/yandexuid_to_icookie';
$icookie_yuid = $prefix || '/dicts/icookie_to_yandexuid';

-- ========================================================================== --

$active_pairs = (
    SELECT
        CAST(id1 AS UInt64) ?? 0 AS yandexuid,
        CAST(id2 AS UInt64) ?? 0 AS icookie
    FROM $soup_table
    WHERE ListMax(dates) > $min_active_date
);

INSERT INTO $yuid_icookie WITH TRUNCATE
SELECT
    yandexuid,
    Unwrap(MODE(icookie)[0].Value) AS icookie,
    TopFreq(icookie, $TPF_BUFF) AS icookies
FROM $active_pairs
WHERE yandexuid > 0
GROUP BY yandexuid
ORDER BY yandexuid;

INSERT INTO $icookie_yuid WITH TRUNCATE
SELECT
    icookie,
    Unwrap(MODE(yandexuid)[0].Value) AS yandexuid,
    TopFreq(yandexuid, $TPF_BUFF) AS yandexuids
FROM $active_pairs
WHERE icookie > 0
GROUP BY icookie
ORDER BY icookie;
