#pragma once

#include <mapreduce/yt/common/config.h>
#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/interface/operation.h>
#include <mapreduce/yt/util/ypath_join.h>
#include <crypta/graph/soup/edge_weights/proto/stats.pb.h>
#include <library/cpp/protobuf/yql/descriptor.h>
#include <util/generic/vector.h>
#include <util/stream/str.h>
#include <util/generic/hash_set.h>
#include <iostream>
#include <algorithm>
#include <ctime>

namespace NEdgeStats {
    namespace NEdgeFields {

        TString GetEdgeType(const TString& sourceType, const TString& logSource, const TString& id1Type, const TString& id2Type);

        TString GetEdgeType(const NYT::TNode& row);

        template <typename Dates>
        TVector<i64> GetSortedTimestamps(const Dates& dates);

        TVector<i64> GetSortedTimestamps(const NYT::TNode& row);
    }

    double GetDefaultSurvivalFunctionValue(i64 daysCount, i64 duration);

    double GetSurvivalFunctionValue(i64 daysCount, i64 duration, const TTotalHistogram& totalHistogram);

    double GetSurvivalFunctionValue(i64 currentTimestamp, const TVector<i64>& timestamps, const TTotalHistogram& totalHistogram);

    double GetSurvivalFunctionValue(i64 currentTimestamp, const NYT::TNode& row, const TTotalHistogram& totalHistogram);

    double GetSurvivalFunctionValue(i64 currentTimestamp, const TStatsQuery& query);

    double GetSurvivalFunctionValue(i64 currentTimestamp, TString& stringTStatsQuery);

    void CollectStats(NYT::IClientPtr& client, i64 currentTimestamp, const TVector<TString>& sources, const TString& destination);

    void CollectStats(NYT::IClientPtr& client, i64 currentTimestamp, const TString& soupDir, const TString& destination);

    class TStatsCollector {
    public:
        explicit TStatsCollector(ui64 daysCountStepsSize = 9, ui64 durationStepsSize = 10);

        TTotalHistogram ConvertToHistograms();

        void UpdateWith(const TTotalHistogram& totalHistogram);

        void UpdateWith(ui64 daysCount, ui64 duration);

        void UpdateWith(TVector<i64>& timestamps, i64 currentTimestamp, i64 deathTimeout);

        const TVector<TVector<ui64>> GetCounts();

        ui64 GetUsersCount();

    private:
        TVector<ui64> DaysCountSteps;
        TVector<ui64> DurationsSteps;
        TVector<TVector<ui64>> Counts;
        ui64 UsersCount;
        ui64 LastObservedTimestamp = 0;
        ui64 StatsCreationTime = 0;

        void Init(ui64 daysCountStepsSize, ui64 durationStepsSize);

        TVector<ui64> GetPowers(ui64 size, i64 ratio = 2);
    };

}
