#include <mapreduce/yt/common/config.h>
#include <mapreduce/yt/interface/client.h>
#include <crypta/graph/soup/edge_weights/lib/stats.h>
#include <library/cpp/getopt/last_getopt.h>
#include <ctime>

void CollectEdgeStats(const TString& soupDir, const TString& destination) {
    auto client = NYT::CreateClient("hahn");
    NYT::TConfig::Get()->UseClientProtobuf = false;

    i64 currentTimestamp = std::time(0);
    NEdgeStats::CollectStats(client, currentTimestamp, soupDir, destination);
}

int main(int argc, const char** argv) {
    NYT::Initialize(argc, argv);
    NLastGetopt::TOpts options;
    TString soupDir;
    options.AddCharOption('s', "source soup directory")
        .Required()
        .StoreResult(&soupDir);
    TString edgeStatsPath;
    options.AddCharOption('d', "destination path for edge statistics")
        .Required()
        .StoreResult(&edgeStatsPath);
    NLastGetopt::TOptsParseResult optParsing(&options, argc, argv);

    CollectEdgeStats(soupDir, edgeStatsPath);
    return 0;
}
