package ru.yandex.crypta.graph2.model.soup.edge;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import com.google.protobuf.ByteString;

import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph.soup.config.proto.ELogSourceType;
import ru.yandex.crypta.graph.soup.config.proto.ESourceType;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeProps;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeType;
import ru.yandex.crypta.graph2.model.soup.proto.Edge;
import ru.yandex.crypta.graph2.model.soup.proto.EdgeType;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.impl.ytree.serialization.YTreeBinarySerializer;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

public class EdgeProtoHelper {
    public static final String DATES_COLUMN = "dates";

    public static final Comparator<TEdgeProps.EEdgeStrength> EDGE_STRENGTH_COMPARATOR = Comparator
            .comparingInt(TEdgeProps.EEdgeStrength::getNumber);

    public static EdgeType getEdgeType(Edge edge) {
        // TODO: think about cache
        return EdgeType.newBuilder()
                .setId1Type(edge.getId1Type())
                .setId2Type(edge.getId2Type())
                .setSourceType(edge.getSourceType())
                .setLogSource(edge.getLogSource())
                .build();
    }

    public static EdgeType convertToProtoEdgeType(ru.yandex.crypta.graph2.model.soup.edge.EdgeType edgeType) {
        return createEdgeType(
                edgeType.getId1Type(),
                edgeType.getId2Type(),
                edgeType.getSourceType(),
                edgeType.getLogSource()
        );
    }

    public static EdgeType createEdgeType(EIdType id1Type, EIdType id2Type, ESourceType sourceType,
                                          ELogSourceType logSourceType) {
        return createEdgeType(
                Soup.CONFIG.name(id1Type),
                Soup.CONFIG.name(id2Type),
                Soup.CONFIG.name(sourceType),
                Soup.CONFIG.name(logSourceType)
        );
    }

    public static EdgeType createEdgeType(String id1Type, String id2Type, String sourceType, String logSource) {
        return EdgeType.newBuilder()
                .setId1Type(id1Type)
                .setId2Type(id2Type)
                .setSourceType(sourceType)
                .setLogSource(logSource)
                .build();
    }

    public static List<String> getDates(Edge edge) {
        ByteString datesBin = edge.getDates();
        if (datesBin.isEmpty()) {
            return List.of();
        } else {
            InputStream inputStream = datesBin.newInput();
            YTreeNode datesYson = YTreeBinarySerializer.deserialize(inputStream);
            return datesYson
                    .asList()
                    .stream()
                    .map(YTreeNode::stringValue)
                    .collect(Collectors.toList());
        }
    }

    public static void setDates(Edge.Builder edgeBuilder, List<String> dates) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();

        YTreeNode node = YTree.builder().value(dates).build();
        YTreeBinarySerializer.serialize(node, os);

        ByteString datesField = ByteString.copyFrom(os.toByteArray());
        edgeBuilder.setDates(datesField);
    }

    public static String getTableName(EIdType id1Type, EIdType id2Type,
                                      ESourceType sourceType, ELogSourceType logSource) {
        return String.join("_",
                Soup.CONFIG.name(id1Type),
                Soup.CONFIG.name(id2Type),
                Soup.CONFIG.name(sourceType),
                Soup.CONFIG.name(logSource)
        );
    }

    public static String getTableName(TEdgeType edgeType) {
        return getTableName(
                edgeType.getId1Type(),
                edgeType.getId2Type(),
                edgeType.getSourceType(),
                edgeType.getLogSource()
        );
    }


}
