package ru.yandex.crypta.graph2.model.soup.edge;

import java.util.Comparator;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph.soup.config.proto.ELogSourceType;
import ru.yandex.crypta.graph.soup.config.proto.ESourceType;
import ru.yandex.crypta.graph2.dao.yt.schema.extractor.CustomColumnType;
import ru.yandex.crypta.graph2.model.soup.sources.ProtobufEnumLogSourceSerializer;
import ru.yandex.crypta.graph2.model.soup.sources.ProtobufEnumSourceTypeSerializer;
import ru.yandex.crypta.graph2.model.soup.vertex.ProtobufEnumIdTypeSerializer;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;
import ru.yandex.crypta.lib.proto.identifiers.ERepresentedObjectType;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeSerializerClass;
import ru.yandex.yt.ytclient.tables.ColumnValueType;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class EdgeType implements Comparable<EdgeType>, YtSerializable {

    public static final ListF<String> EDGE_TYPE_UNIQUE_KEY = Cf.list("id1Type", "id2Type", "sourceType", "logSource");
    private static final Comparator<EdgeType> STRAIGHT_COMP = Comparator
            .<EdgeType, String>comparing(et -> Soup.CONFIG.name(et.id1Type))
            .thenComparing(et -> Soup.CONFIG.name(et.id2Type))
            .thenComparing(et -> Soup.CONFIG.name(et.sourceType))
            .thenComparing(et -> Soup.CONFIG.name(et.logSource));


    @YTreeField
    @YTreeSerializerClass(ProtobufEnumIdTypeSerializer.class)
    @CustomColumnType(ColumnValueType.STRING)
    private EIdType id1Type;

    @YTreeField
    @YTreeSerializerClass(ProtobufEnumIdTypeSerializer.class)
    @CustomColumnType(ColumnValueType.STRING)
    private EIdType id2Type;

    @YTreeField
    @YTreeSerializerClass(ProtobufEnumSourceTypeSerializer.class)
    @CustomColumnType(ColumnValueType.STRING)
    private ESourceType sourceType;

    @YTreeField
    @YTreeSerializerClass(ProtobufEnumLogSourceSerializer.class)
    @CustomColumnType(ColumnValueType.STRING)
    private ELogSourceType logSource;

    public EdgeType(EIdType id1Type, EIdType id2Type, ESourceType sourceType, ELogSourceType logSource) {
        this.id1Type = id1Type;
        this.id2Type = id2Type;
        this.sourceType = sourceType;
        this.logSource = logSource;
    }

    public static String getTableName(EIdType id1Type, EIdType id2Type,
                                      ESourceType sourceType, ELogSourceType logSource) {
        return String.join("_",
                Soup.CONFIG.name(id1Type),
                Soup.CONFIG.name(id2Type),
                Soup.CONFIG.name(sourceType),
                Soup.CONFIG.name(logSource)
        );
    }

    public EIdType getId1Type() {
        return id1Type;
    }

    public EIdType getId2Type() {
        return id2Type;
    }

    public ESourceType getSourceType() {
        return sourceType;
    }

    public ELogSourceType getLogSource() {
        return logSource;
    }

    public String getTableName() {
        return getTableName(id1Type, id2Type, sourceType, logSource);
    }

    public boolean isWithinDevice() {
        return Soup.CONFIG.getIdType(id1Type).getRepObj() != ERepresentedObjectType.PERSON &&
                Soup.CONFIG.getIdType(id2Type).getRepObj() != ERepresentedObjectType.PERSON;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdgeType)) {
            return false;
        }

        EdgeType edgeType = (EdgeType) o;

        if (id1Type != edgeType.id1Type) {
            return false;
        }
        if (id2Type != edgeType.id2Type) {
            return false;
        }
        if (sourceType != edgeType.sourceType) {
            return false;
        }
        return logSource == edgeType.logSource;
    }

    @Override
    public int hashCode() {
        int result = id1Type.hashCode();
        result = 31 * result + id2Type.hashCode();
        result = 31 * result + sourceType.hashCode();
        result = 31 * result + logSource.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return getTableName();
    }

    @Override
    public int compareTo(EdgeType other) {
        return STRAIGHT_COMP.compare(this, other);
    }
}
