package ru.yandex.crypta.graph2.model.soup.edge;

import java.util.Map.Entry;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.crypta.graph2.dao.yt.utils.YTreeUtils;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject
public class EdgeTypeActivityStats implements YtSerializable, Comparable<EdgeTypeActivityStats> {

    @YTreeField
    @YTreeFlattenField
    private EdgeType edgeType;

    @YTreeField
    private MapF<String, Long> datesCountHist;
    @YTreeField
    private MapF<String, Long> lifetimeDaysHist;

    public EdgeTypeActivityStats(EdgeType edgeType) {
        this(edgeType, Cf.hashMap(), Cf.hashMap());
    }

    public EdgeTypeActivityStats(EdgeType edgeType, Integer datesCount, Integer lifetimeDays) {
        this(edgeType, Cf.map(datesCount, 1L), Cf.map(lifetimeDays, 1L));
    }

    public EdgeTypeActivityStats(EdgeType edgeType, MapF<Integer, Long> datesCountHist, MapF<Integer, Long> lifetimeDaysHist) {
        this.edgeType = edgeType;
        this.datesCountHist = YTreeUtils.typedKeyToString(datesCountHist);
        this.lifetimeDaysHist = YTreeUtils.typedKeyToString(lifetimeDaysHist);
    }

    public EdgeType getEdgeType() {
        return edgeType;
    }

    public MapF<Integer, Long> getDatesCountHist() {
        return YTreeUtils.stringKeyToInt(datesCountHist);
    }

    public MapF<Integer, Long> getLifetimeDaysHist() {
        return YTreeUtils.stringKeyToInt(lifetimeDaysHist);
    }


    public EdgeTypeActivityStats merge(EdgeTypeActivityStats other) {
        this.datesCountHist = mergeHistogramsSumValues(this.datesCountHist, other.datesCountHist);
        this.lifetimeDaysHist = mergeHistogramsSumValues(this.lifetimeDaysHist, other.lifetimeDaysHist);

        return this;
    }

    private MapF<String, Long> mergeHistogramsSumValues(MapF<String, Long> h1, MapF<String, Long> h2) {
        MapF<String, Long> result = Cf.hashMap();
        for (Entry<String, Long> entry : h1.entrySet()) {
            result.merge(entry.getKey(), entry.getValue(), (v1, v2) -> v1 + v2);
        }
        for (Entry<String, Long> entry : h2.entrySet()) {
            result.merge(entry.getKey(), entry.getValue(), (v1, v2) -> v1 + v2);
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdgeTypeActivityStats)) {
            return false;
        }

        EdgeTypeActivityStats that = (EdgeTypeActivityStats) o;

        return edgeType.equals(that.edgeType);
    }

    @Override
    public int hashCode() {
        return edgeType.hashCode();
    }

    @Override
    public int compareTo(EdgeTypeActivityStats o) {
        return this.edgeType.compareTo(o.edgeType);
    }
}
