package ru.yandex.crypta.graph2.model.soup.edge;

import java.util.Comparator;
import java.util.Objects;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph2.dao.yt.schema.extractor.CustomColumnType;
import ru.yandex.crypta.graph2.model.soup.vertex.ProtobufEnumIdTypeSerializer;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeSerializerClass;
import ru.yandex.yt.ytclient.tables.ColumnValueType;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class MultiEdgeKey implements Comparable<MultiEdgeKey> {

    public static final ListF<String> MULTI_EDGE_UNIQUE_KEY = Cf.list("id1Type", "id2Type", "id1", "id2");
    public static final Comparator<MultiEdgeKey> COMPARATOR = Comparator
            .comparing(MultiEdgeKey::getId1)
            .thenComparing(MultiEdgeKey::getId1Type)
            .thenComparing(MultiEdgeKey::getId2)
            .thenComparing(MultiEdgeKey::getId2Type);

    @YTreeField
    private String id1;
    @YTreeField
    @YTreeSerializerClass(ProtobufEnumIdTypeSerializer.class)
    @CustomColumnType(ColumnValueType.STRING)
    private EIdType id1Type;

    @YTreeField
    private String id2;
    @YTreeField
    @YTreeSerializerClass(ProtobufEnumIdTypeSerializer.class)
    @CustomColumnType(ColumnValueType.STRING)
    private EIdType id2Type;

    public MultiEdgeKey(String id1, EIdType id1Type, String id2, EIdType id2Type) {
        this.id1 = id1;
        this.id1Type = id1Type;
        this.id2 = id2;
        this.id2Type = id2Type;

    }

    public String getId1() {
        return id1;
    }

    public EIdType getId1Type() {
        return id1Type;
    }

    public String getId2() {
        return id2;
    }

    public EIdType getId2Type() {
        return id2Type;
    }

    public Vertex getLeftVertex() {
        return new Vertex(id1, id1Type);
    }

    public Vertex getRightVertex() {
        return new Vertex(id2, id2Type);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiEdgeKey)) {
            return false;
        }
        MultiEdgeKey that = (MultiEdgeKey) o;
        return Objects.equals(id1, that.id1) &&
                id1Type == that.id1Type &&
                Objects.equals(id2, that.id2) &&
                id2Type == that.id2Type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id1, id1Type, id2, id2Type);
    }

    @Override
    public int compareTo(MultiEdgeKey o) {
        return COMPARATOR.compare(this, o);
    }

    public String repr() {
        // id1(id1Type)-id2(id2Type)
        return this.id1 + "(" + Soup.CONFIG.name(this.id1Type) + ")-"
                + this.id2 + "(" + Soup.CONFIG.name(this.id2Type) + ")";
    }

    @Override
    public String toString() {
        return repr();
    }
}
