package ru.yandex.crypta.graph2.model.soup.edge.weight;

import ru.yandex.crypta.graph.soup.config.proto.TEdgeRecord;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.crypta.graph2.model.soup.edge.EdgeProtoHelper;
import ru.yandex.crypta.graph2.model.soup.sources.DefaultEdgeTypeConfigProvider;
import ru.yandex.crypta.graph2.model.soup.sources.EdgeTypeConfigProvider;

public class DefaultEdgeInfoProvider implements EdgeInfoProvider {

    private final EdgeTypeConfigProvider edgeTypeConfigProvider;

    public DefaultEdgeInfoProvider(EdgeTypeConfigProvider edgeTypeConfigProvider) {
        this.edgeTypeConfigProvider = edgeTypeConfigProvider;
    }

    public DefaultEdgeInfoProvider() {
        this.edgeTypeConfigProvider = new DefaultEdgeTypeConfigProvider();
    }

    @Override
    public double getEdgeWeight(Edge edge) {
        return edge.getDatesWeight().getOrElse(0.0);
    }

    @Override
    public double getEdgeWeight(ru.yandex.crypta.graph2.model.soup.proto.Edge edge) {
        return edge.getDatesWeight();
    }

    @Override
    public TEdgeRecord getEdgeTypeConfig(Edge edge) {
        return edgeTypeConfigProvider.getEdgeTypeConfig(edge.calculateEdgeType());
    }

    @Override
    public TEdgeRecord getEdgeTypeConfig(ru.yandex.crypta.graph2.model.soup.proto.Edge edge) {
        return edgeTypeConfigProvider.getEdgeTypeConfig(
                EdgeProtoHelper.getEdgeType(edge)
        );
    }
}
