package ru.yandex.crypta.graph2.model.soup.edge.weight;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeProps;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeRecord;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.crypta.graph2.model.soup.edge.EdgeProtoHelper;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;

public interface EdgeInfoProvider extends YtSerializable {

    double getEdgeWeight(Edge edge);

    double getEdgeWeight(ru.yandex.crypta.graph2.model.soup.proto.Edge edge);

    TEdgeRecord getEdgeTypeConfig(Edge edge);

    TEdgeRecord getEdgeTypeConfig(ru.yandex.crypta.graph2.model.soup.proto.Edge edge);

    default TEdgeProps.EEdgeStrength getEdgeTypeStrength(Edge edge) {
        return getEdgeTypeConfig(edge).getProps().getEdgeStrength();
    }

    default TEdgeProps.EEdgeStrength getEdgeTypeStrength(ru.yandex.crypta.graph2.model.soup.proto.Edge edge) {
        return getEdgeTypeConfig(edge).getProps().getEdgeStrength();
    }

    default boolean hasActivity(Edge edge) {
        return getEdgeTypeConfig(edge).getProps().getActivityType() != TEdgeProps.EActivityType.NONE;
    }

    default boolean hasActivity(ru.yandex.crypta.graph2.model.soup.proto.Edge edge) {
        return getEdgeTypeConfig(edge).getProps().getActivityType() != TEdgeProps.EActivityType.NONE;
    }

    default boolean isStrong(Edge edge) {
        var edgeStrength = getEdgeTypeConfig(edge).getProps().getEdgeStrength();
        return isStrong(edgeStrength);
    }

    default boolean isStrong(ru.yandex.crypta.graph2.model.soup.proto.Edge edge) {
        var edgeStrength = getEdgeTypeConfig(edge).getProps().getEdgeStrength();
        return EdgeInfoProvider.this.isStrong(edgeStrength);
    }

    default boolean isStrong(TEdgeProps.EEdgeStrength edgeStrength) {
        return edgeStrength == TEdgeProps.EEdgeStrength.TRUSTED || edgeStrength == TEdgeProps.EEdgeStrength.ARTIFICIAL;
    }

    default boolean isIndevice(Edge edge) {
        var deviceBounds = getEdgeTypeConfig(edge).getProps().getDeviceBounds();
        return deviceBounds == TEdgeProps.EDeviceBounds.INDEVICE;
    }

    default boolean isIndevice(ru.yandex.crypta.graph2.model.soup.proto.Edge edge) {
        var deviceBounds = getEdgeTypeConfig(edge).getProps().getDeviceBounds();
        return deviceBounds == TEdgeProps.EDeviceBounds.INDEVICE;
    }

    default TEdgeProps.EEdgeStrength getMaxEdgeTypeStrength(CollectionF<Edge> edges) {
        return edges
                .map(this::getEdgeTypeStrength)
                .maxO(EdgeProtoHelper.EDGE_STRENGTH_COMPARATOR)
                .getOrElse(TEdgeProps.EEdgeStrength.UNKNOWN);
    }

    default TEdgeProps.EEdgeStrength getMaxProtoEdgeTypeStrength(CollectionF<ru.yandex.crypta.graph2.model.soup.proto.Edge> edges) {
        return edges
                .map(this::getEdgeTypeStrength)
                .maxO(EdgeProtoHelper.EDGE_STRENGTH_COMPARATOR)
                .getOrElse(TEdgeProps.EEdgeStrength.UNKNOWN);
    }

    default double getMultiEdgeWeight(CollectionF<Edge> edges) {
        return edges.map(this::getEdgeWeight).sum(Cf.Double);
    }

    default EdgeScore getMultiEdgeScore(CollectionF<Edge> edges) {
        return new EdgeScore(
                getMaxEdgeTypeStrength(edges),
                getMultiEdgeWeight(edges)
        );
    }
}
