package ru.yandex.crypta.graph2.model.soup.edge.weight;

import java.util.Comparator;

import ru.yandex.crypta.graph.soup.config.proto.TEdgeProps;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject
public class EdgeScore {

    public static final Comparator<EdgeScore> COMPARATOR = Comparator
            .comparing(EdgeScore::getStrength)
            .thenComparing(EdgeScore::getWeight);

    @YTreeField
    private TEdgeProps.EEdgeStrength strength;
    @YTreeField
    private double weight;


    public EdgeScore(TEdgeProps.EEdgeStrength strength, double weight) {
        this.strength = strength;
        this.weight = weight;
    }

    public TEdgeProps.EEdgeStrength getStrength() {
        return strength;
    }

    public double getWeight() {
        return weight;
    }
}
