package ru.yandex.crypta.graph2.model.soup.edge.weight;

import ru.yandex.crypta.graph.soup.config.proto.TEdgeRecord;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.crypta.graph2.model.soup.sources.DefaultEdgeTypeConfigProvider;
import ru.yandex.crypta.graph2.model.soup.sources.EdgeTypeConfigProvider;

import static ru.yandex.crypta.graph2.model.soup.edge.EdgeProtoHelper.getEdgeType;

public class SurvivalEdgeInfoProvider implements EdgeInfoProvider {

    private final EdgeTypeConfigProvider edgeTypeConfigProvider;

    public SurvivalEdgeInfoProvider() {
        this.edgeTypeConfigProvider = new DefaultEdgeTypeConfigProvider();
    }

    @Override
    public double getEdgeWeight(Edge edge) {
        return edge.getSurvivalWeight().getOrElse(0.0);
    }

    @Override
    public TEdgeRecord getEdgeTypeConfig(Edge edge) {
        return edgeTypeConfigProvider.getEdgeTypeConfig(edge.calculateEdgeType());
    }

    @Override
    public double getEdgeWeight(ru.yandex.crypta.graph2.model.soup.proto.Edge edge) {
        return edge.getSurvivalWeight();
    }

    @Override
    public TEdgeRecord getEdgeTypeConfig(ru.yandex.crypta.graph2.model.soup.proto.Edge edge) {
        return edgeTypeConfigProvider.getEdgeTypeConfig(
                getEdgeType(edge)
        );
    }
}
