package ru.yandex.crypta.graph2.model.soup.edge.weight.estimator;

import java.util.List;

import ru.yandex.crypta.graph2.model.soup.edge.EdgeProtoHelper;
import ru.yandex.crypta.graph2.model.soup.proto.Edge;
import ru.yandex.crypta.graph2.model.soup.proto.EdgeType;
import ru.yandex.crypta.graph2.model.soup.sources.EdgeTypeConfigProvider;

public class DatesActivityEdgeWeightEstimator implements EdgeWeightEstimator {
    private final EdgeTypeConfigProvider edgeTypeConfigProvider;

    public DatesActivityEdgeWeightEstimator(EdgeTypeConfigProvider edgeTypeConfigProvider) {
        this.edgeTypeConfigProvider = edgeTypeConfigProvider;
    }

    @Override
    public double getEdgeWeight(Edge edge) {
        EdgeType edgeType = EdgeProtoHelper.getEdgeType(edge);
        List<String> dates = EdgeProtoHelper.getDates(edge);

        double baseWeight = edgeTypeConfigProvider.getBaseWeight(edgeType);

        if (edgeTypeConfigProvider.hasActivity(edgeType)) {
            return dates.size() * baseWeight;
        } else {
            return baseWeight; // artificial edges has no activity
        }
    }
}
