package ru.yandex.crypta.graph2.model.soup.props;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class CommonShared implements VertexProperties {
    public static final String COMMON_SHARED_SOURCE = "common_shared";

    @YTreeField
    @YTreeFlattenField
    private Vertex vertex;

    @YTreeField
    private String cryptaId;

    @YTreeField
    private String source;

    //    @YTreeField(key = "shared_types")
    // temporary disabled till migration to protobuf format
    private ListF<String> sharedTypes;

    public CommonShared(Vertex vertex, String cryptaId, String source,
                        ListF<String> sharedTypes) {
        this.vertex = vertex;
        this.cryptaId = cryptaId;
        this.source = source;
        this.sharedTypes = sharedTypes;
    }

    @Override
    public Vertex getVertex() {
        return vertex;
    }

    @Override
    public String getCryptaId() {
        return cryptaId;
    }

    @Override
    public void setCryptaId(String cryptaId) {
        this.cryptaId = cryptaId;
    }

    @Override
    public String getSource() {
        return source;
    }

    public ListF<String> getSharedTypes() {
        return sharedTypes;
    }
}
