package ru.yandex.crypta.graph2.model.soup.props;

import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class DeviceId implements VertexProperties, HasActivity {

    public static final String APP_METRICA_SOURCE = "mm";

    @YTreeField
    @YTreeFlattenField
    private Vertex vertex;

    @YTreeField
    private String cryptaId;

    @YTreeField(key = "ua_profile")
    private String uaProfile;

    @YTreeField(key = "device_type")
    @SuppressWarnings("UnusedVariable")
    private String deviceType;

    @YTreeField
    private String os;

    @YTreeField(key = "main_region")
    private Option<Integer> mainRegion;

    @YTreeField(key = "main_region_country")
    @SuppressWarnings("UnusedVariable")
    private Option<Integer> mainRegionCountry;

    @YTreeField(key = IS_ACTIVE_COLUMN)
    private boolean isActive;

    @YTreeField
    private String source;

    public DeviceId() {
    }

    public DeviceId(Vertex vertex, String cryptaId, String uaProfile, String deviceType,
                    String os, Option<Integer> mainRegion, String source, boolean isActive) {
        this.vertex = vertex;
        this.cryptaId = cryptaId;
        this.uaProfile = uaProfile;
        this.deviceType = deviceType;
        this.os = os;
        this.mainRegion = mainRegion;
        this.mainRegionCountry = Option.empty();
        this.source = source;
        this.isActive = isActive;
    }

    @Override
    public Vertex getVertex() {
        return vertex;
    }

    public void setVertex(Vertex vertex) {
        this.vertex = vertex;
    }

    public String getUaProfile() {
        return uaProfile;
    }

    public void setUaProfile(String uaProfile) {
        this.uaProfile = uaProfile;
    }

    public String getOs() {
        return os;
    }

    @Override
    public String getCryptaId() {
        return cryptaId;
    }

    @Override
    public void setCryptaId(String cryptaId) {
        this.cryptaId = cryptaId;
    }

    @Override
    public String getSource() {
        return source;
    }

    public Option<Integer> getMainRegion() {
        return mainRegion;
    }

    @Override
    public boolean isActive() {
        return isActive;
    }
}
