package ru.yandex.crypta.graph2.model.soup.props;

import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class Outlier implements VertexProperties {
    public static final String OUTLIER_SOURCE = "outliers";

    @YTreeField
    @YTreeFlattenField
    private Vertex vertex;

    @YTreeField
    private String cryptaId;

    @YTreeField(key = "source")
    private String source;

    @YTreeField(key = "id")
    @SuppressWarnings("UnusedVariable")
    private String id;

    @YTreeField(key = "id_type")
    @SuppressWarnings("UnusedVariable")
    private String idType;

    @YTreeField(key = "anomaly_score")
    private Double anomalyScore;

    public Outlier(Vertex vertex, String cryptaId, String source, String id, String idType, Double anomalyScore) {
        this.vertex = vertex;
        this.cryptaId = cryptaId;
        this.source = source;
        this.id = id;
        this.idType = idType;
        this.anomalyScore = anomalyScore;
    }

    @Override
    public Vertex getVertex() {
        return vertex;
    }

    @Override
    public String getCryptaId() {
        return cryptaId;
    }

    @Override
    public void setCryptaId(String cryptaId) {
        this.cryptaId = cryptaId;
    }

    @Override
    public String getSource() {
        return source;
    }

    public Double getAnomalyScore() {
        return anomalyScore;
    }
}
