package ru.yandex.crypta.graph2.model.soup.props;

import java.util.Arrays;

import static ru.yandex.crypta.graph2.model.soup.props.UaProfile.UserAgentEquality.EQUALS;
import static ru.yandex.crypta.graph2.model.soup.props.UaProfile.UserAgentEquality.NOT_EQUAL;
import static ru.yandex.crypta.graph2.model.soup.props.UaProfile.UserAgentEquality.ROUGHLY_EQUALS;

public class UaProfile {

    private static final int MOBILE_UA_PROFILE_SECTIONS_N = 5;
    private static final int DESKTOP_UA_PROFILE_SECTIONS_N = 4;
    private static final String MOBILE = "m";
    private static final String DESKTOP = "d";

    private String[] uaProfileParts;

    public UaProfile(String uaProfile) {
        this(uaProfile.split("[|]"));
    }

    public UaProfile(String[] uaProfileParts) {
        this.uaProfileParts = uaProfileParts;
    }

    public static UserAgentEquality compareUaProfiles(UaProfile uaProfile1, UaProfile uaProfile2) {

        if (!uaProfile1.isFull() || !uaProfile2.isFull()) {
            return NOT_EQUAL;
        }

        if (uaProfile1.equals(uaProfile2)) {
            return EQUALS;
        }

        UaProfile uaProfile1NoVersion = uaProfile1.withoutVersion();
        UaProfile uaProfile2NoVersion = uaProfile2.withoutVersion();
        if (uaProfile1NoVersion != null && uaProfile1NoVersion.equals(uaProfile2NoVersion)) {
            return ROUGHLY_EQUALS;
        } else {
            return NOT_EQUAL;
        }
    }

    public boolean isFull() {
        return uaProfileParts.length > 0 && uaProfileParts.length == fullPartsCount();
    }

    public boolean isMobile() {
        return uaProfileParts.length > 0 && uaProfileParts[0].equals(MOBILE);
    }

    public boolean isDesktop() {
        return uaProfileParts.length > 0 && uaProfileParts[0].equals(DESKTOP);
    }

    private int fullPartsCount() {
        if (isMobile()) {
            // "m|device_type|vendor|os|version"
            return MOBILE_UA_PROFILE_SECTIONS_N;

        } else if (isDesktop()) {
            // "m|device_type|os|version"
            return DESKTOP_UA_PROFILE_SECTIONS_N;
        } else {
            return 0;
        }
    }

    public String[] getUaProfileParts() {
        return uaProfileParts;
    }

    public UaProfile withoutVersion() {
        int requiredLength = fullPartsCount();
        if (uaProfileParts.length == requiredLength) {
            return new UaProfile(Arrays.copyOf(uaProfileParts, requiredLength - 1));
        } else {
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UaProfile uaProfile)) {
            return false;
        }
        return Arrays.equals(uaProfileParts, uaProfile.uaProfileParts);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(uaProfileParts);
    }

    public enum UserAgentEquality {
        EQUALS,
        ROUGHLY_EQUALS,
        NOT_EQUAL;

        public boolean atLeastRoughlyEquals() {
            return this == EQUALS || this == ROUGHLY_EQUALS;
        }

    }
}
