package ru.yandex.crypta.graph2.model.soup.props;

import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class Uuid implements VertexProperties, HasActivity {

    @YTreeField
    @YTreeFlattenField
    private Vertex vertex;

    @YTreeField
    private String cryptaId;

    @YTreeField(key = "app_id")
    private String appId;

    @YTreeField
    private String source;

    @YTreeField(key = IS_ACTIVE_COLUMN)
    private boolean isActive;

    public String getAppId() {
        return appId;
    }

    @Override
    public Vertex getVertex() {
        return this.vertex;
    }

    @Override
    public String getCryptaId() {
        return cryptaId;
    }

    @Override
    public void setCryptaId(String cryptaId) {
        this.cryptaId = cryptaId;
    }

    @Override
    public String getSource() {
        return source;
    }

    @Override
    public boolean isActive() {
        return isActive;
    }

    public Uuid(Vertex vertex, String cryptaId, String appId, String source, boolean isActive) {
        this.vertex = vertex;
        this.cryptaId = cryptaId;
        this.appId = appId;
        this.source = source;
        this.isActive = isActive;
    }
}
