package ru.yandex.crypta.graph2.model.soup.props;

import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.model.soup.props.info.ExactSocdem;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class VertexExactSocdem implements VertexProperties {

    public static final String EXACT_SOCDEM_SOURCE = "exact_socdem";
    public static final String GENDER_COLUMN = "gender";
    public static final String SOCDEM_SOURCE_COLUMN = "socdem_source";

    @YTreeField
    @YTreeFlattenField
    private Vertex vertex;

    @YTreeField
    private String cryptaId;

    @YTreeField
    @YTreeFlattenField
    private ExactSocdem socdem = ExactSocdem.EMPTY;

    @YTreeField
    private String source;

    @Override
    public Vertex getVertex() {
        return vertex;
    }

    public ExactSocdem getSocdem() {
        return socdem;
    }

    @Override
    public String getCryptaId() {
        return cryptaId;
    }

    @Override
    public void setCryptaId(String cryptaId) {
        this.cryptaId = cryptaId;
    }

    @Override
    public String getSource() {
        return source;
    }

    public VertexExactSocdem(Vertex vertex, String cryptaId, ExactSocdem socdem, String source, Option<String> socdemSource) {
        this.vertex = vertex;
        this.cryptaId = cryptaId;
        this.socdem = socdem;
        this.source = source;
    }
}
