package ru.yandex.crypta.graph2.model.soup.props;

import java.util.List;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.dao.yt.schema.extractor.YTreeYtSchemaExtractor;
import ru.yandex.crypta.graph2.dao.yt.schema.extractor.YtSchemaExtractor;
import ru.yandex.yt.ytclient.tables.ColumnSchema;
import ru.yandex.yt.ytclient.tables.ColumnValueType;
import ru.yandex.yt.ytclient.tables.TableSchema;

public class VertexPropertiesSchemaHelper {

    private static final YtSchemaExtractor SCHEMA_EXTRACTOR = new YTreeYtSchemaExtractor();
    // from ru.yandex.crypta.graph2.model.matching.merge.MergeKey
    private static final List<ColumnSchema> ADDITIONAL_MATCHING_COLUMNS = List.of(
            new ColumnSchema("merge_key", ColumnValueType.STRING),
            new ColumnSchema("merge_key_type", ColumnValueType.STRING)
    );

    private static final List<ColumnSchema> OLD_PROB_SOCDEM_COLUMNS = List.of(
            new ColumnSchema("genderSegments", ColumnValueType.ANY),
            new ColumnSchema("ageSegments", ColumnValueType.ANY)
    );

    private static final ColumnSchema DATES_COLUMN = new ColumnSchema(
            VertexProperties.DATES_COLUMN, ColumnValueType.ANY
    );

    private static ListF<Class<? extends VertexProperties>> getAllSocdemClasses() {
        return Cf.list(
                VertexExactSocdem.class,
                VertexSocdemProbSegments.class
        );
    }

    private static ListF<Class<? extends VertexProperties>> getAllSharedClasses() {
        return Cf.list(
                CommonShared.class
        );
    }

    private static ListF<Class<? extends VertexProperties>> getAllOutliersClasses() {
        return Cf.list(
                Outlier.class
        );
    }

    private static ListF<Class<? extends VertexProperties>> getAllIdsClasses() {
        return Cf.list(
                DeviceId.class,
                Uuid.class,
                Yandexuid.class
        );
    }

    private static ListF<Class<? extends VertexProperties>> getAllVerticesPropertiesChildren() {
        return getAllIdsClasses().plus(getAllSocdemClasses()).plus(getAllSharedClasses()).plus(getAllOutliersClasses());
    }

    public static TableSchema getUnionVertexPropertiesSchema() {
        return SCHEMA_EXTRACTOR
                .extractUnionTableSchema(getAllVerticesPropertiesChildren())
                .toBuilder()
                .addAll(ADDITIONAL_MATCHING_COLUMNS)
                .addAll(OLD_PROB_SOCDEM_COLUMNS)
                .add(DATES_COLUMN)
                .setStrict(false)
                .build();
    }

    public static TableSchema getUnionSocdemPropertiesSchema() {
        return SCHEMA_EXTRACTOR
                .extractUnionTableSchema(getAllSocdemClasses())
                .toBuilder()
                .setStrict(false)
                .build();
    }

    public static TableSchema getUnionIdsPropertiesSchema() {
        return SCHEMA_EXTRACTOR
                .extractUnionTableSchema(getAllIdsClasses())
                .toBuilder()
                .add(DATES_COLUMN)
                .setStrict(false)
                .build();
    }

    public static TableSchema getUnionSharedPropertiesSchema() {
        return SCHEMA_EXTRACTOR
                .extractUnionTableSchema(getAllSharedClasses())
                .toBuilder()
                .setStrict(false)
                .build();
    }

    public static TableSchema getUnionOutliersPropertiesSchema() {
        return SCHEMA_EXTRACTOR
                .extractUnionTableSchema(getAllOutliersClasses())
                .toBuilder()
                .setStrict(false)
                .build();
    }
}
