package ru.yandex.crypta.graph2.model.soup.props;

import ru.yandex.crypta.graph2.model.soup.props.info.ExactSocdem;
import ru.yandex.crypta.graph2.model.soup.props.info.ProbSocdem;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class VertexSocdemProbSegments implements VertexProperties {

    public static final String SOCDEM_SOURCE = "prob_socdem";

    @YTreeField
    @YTreeFlattenField
    private Vertex vertex;

    @YTreeField
    private String cryptaId;

    @YTreeField
    @SuppressWarnings("UnusedVariable")
    private double probMale;

    @YTreeField
    @SuppressWarnings("UnusedVariable")
    private double probFemale;

    @YTreeField
    private String source;

    public VertexSocdemProbSegments(Vertex vertex, ProbSocdem socdem, String source) {
        this.vertex = vertex;
        this.source = source;

        probMale = socdem.getGenderSegments().getOrElse(ExactSocdem.Gender.MALE.value(), 0.);
        probFemale = socdem.getGenderSegments().getOrElse(ExactSocdem.Gender.FEMALE.value(), 0.);
        cryptaId = "";
    }

    @Override
    public Vertex getVertex() {
        return vertex;
    }

    @Override
    public String getCryptaId() {
        return cryptaId;
    }

    @Override
    public void setCryptaId(String cryptaId) {
        this.cryptaId = cryptaId;
    }

    @Override
    public String getSource() {
        return source;
    }
}
