package ru.yandex.crypta.graph2.model.soup.props.info;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;
import ru.yandex.misc.enums.StringEnum;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class ExactSocdem {

    public static final ExactSocdem EMPTY = new ExactSocdem(Option.empty(), Option.empty(), Option.empty());

    @YTreeField(key = "year_of_birth")
    private Option<Integer> yearOfBirth;
    @YTreeField
    private Option<Gender> gender;

    @YTreeField(key = "socdem_source")
    private Option<String> socdemSource;

    public ExactSocdem(Option<Integer> yearOfBirth, Option<Gender> gender, Option<String> socdemSource) {
        this.yearOfBirth = yearOfBirth;
        this.gender = gender;
        this.socdemSource = socdemSource;
    }


    public Option<Integer> getYearOfBirth() {
        return yearOfBirth;
    }

    public Option<Gender> getGender() {
        return gender;
    }

    public Option<String> getSocdemSource() { return socdemSource; }

    public enum Gender implements StringEnum {
        MALE("m"),
        FEMALE("f");

        public static final MapF<String, Gender> COMPATIBILITY_MAP = Cf.map(
                "male", MALE,
                "female", FEMALE,
                "m", MALE,
                "f", FEMALE
        );

        private final String code;

        Gender(String code) {
            this.code = code;
        }

        @Override
        public String value() {
            return code;
        }

    }
}
