package ru.yandex.crypta.graph2.model.soup.sources;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeRecord;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeType;
import ru.yandex.crypta.graph2.model.soup.edge.EdgeProtoHelper;
import ru.yandex.crypta.graph2.model.soup.edge.EdgeType;


public class DefaultEdgeTypeConfigProvider implements EdgeTypeConfigProvider {

    private static final TEdgeRecord DEFAULT_EDGE_TYPE_CONFIG = TEdgeRecord.newBuilder().build();

    private Map<EdgeType, TEdgeRecord> byEdgeType;
    private Map<ru.yandex.crypta.graph2.model.soup.proto.EdgeType, TEdgeRecord> byEdgeTypeProto;

    public DefaultEdgeTypeConfigProvider() {
        byEdgeType = new HashMap<>();
        byEdgeTypeProto = new HashMap<>();

        for (TEdgeType edgeType : Soup.CONFIG.getEdgeTypes()) {
            TEdgeRecord edgeConfig = Soup.CONFIG.getEdgeConfig(edgeType);
            byEdgeType.put(
                    new EdgeType(
                            edgeType.getId1Type(),
                            edgeType.getId2Type(),
                            edgeType.getSourceType(),
                            edgeType.getLogSource()
                    ),
                    edgeConfig
            );

            byEdgeTypeProto.put(
                    EdgeProtoHelper.createEdgeType(
                            Soup.CONFIG.name(edgeType.getId1Type()),
                            Soup.CONFIG.name(edgeType.getId2Type()),
                            Soup.CONFIG.name(edgeType.getSourceType()),
                            Soup.CONFIG.name(edgeType.getLogSource())
                    ),
                    edgeConfig
            );
        }
    }

    @Override
    public TEdgeRecord getEdgeTypeConfig(EdgeType edgeType) {
        return byEdgeType.getOrDefault(edgeType, DEFAULT_EDGE_TYPE_CONFIG);
    }

    @Override
    public TEdgeRecord getEdgeTypeConfig(ru.yandex.crypta.graph2.model.soup.proto.EdgeType edgeType) {
        return byEdgeTypeProto.getOrDefault(edgeType, DEFAULT_EDGE_TYPE_CONFIG);
    }
}
