package ru.yandex.crypta.graph2.model.soup.sources;

import ru.yandex.crypta.graph.soup.config.proto.TEdgeProps;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeRecord;
import ru.yandex.crypta.graph2.model.soup.edge.EdgeType;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;

public interface EdgeTypeConfigProvider extends YtSerializable {
    TEdgeRecord getEdgeTypeConfig(EdgeType edgeType);

    TEdgeRecord getEdgeTypeConfig(ru.yandex.crypta.graph2.model.soup.proto.EdgeType edgeType);

    default boolean isStrong(EdgeType edgeType) {
        var edgeStrength = getEdgeTypeConfig(edgeType).getProps().getEdgeStrength();
        return edgeStrength == TEdgeProps.EEdgeStrength.TRUSTED || edgeStrength == TEdgeProps.EEdgeStrength.ARTIFICIAL;
    }

    default boolean isStrong(ru.yandex.crypta.graph2.model.soup.proto.EdgeType edgeType) {
        var edgeStrength = getEdgeTypeConfig(edgeType).getProps().getEdgeStrength();
        return edgeStrength == TEdgeProps.EEdgeStrength.TRUSTED || edgeStrength == TEdgeProps.EEdgeStrength.ARTIFICIAL;
    }

    default boolean hasActivity(EdgeType edgeType) {
        return getEdgeTypeConfig(edgeType).getProps().getActivityType() != TEdgeProps.EActivityType.NONE;
    }

    default boolean hasActivity(ru.yandex.crypta.graph2.model.soup.proto.EdgeType edgeType) {
        return getEdgeTypeConfig(edgeType).getProps().getActivityType() != TEdgeProps.EActivityType.NONE;
    }

    default double getBaseWeight(EdgeType edgeType) {
        TEdgeProps props = getEdgeTypeConfig(edgeType).getProps();
        return getBaseWeight(props);
    }

    default double getBaseWeight(ru.yandex.crypta.graph2.model.soup.proto.EdgeType edgeType) {
        TEdgeProps props = getEdgeTypeConfig(edgeType).getProps();
        return getBaseWeight(props);
    }

    default boolean isIndevice(EdgeType edge) {
        var deviceBounds = getEdgeTypeConfig(edge).getProps().getDeviceBounds();
        return deviceBounds == TEdgeProps.EDeviceBounds.INDEVICE;
    }

    default boolean isIndevice(ru.yandex.crypta.graph2.model.soup.proto.EdgeType edge) {
        var deviceBounds = getEdgeTypeConfig(edge).getProps().getDeviceBounds();
        return deviceBounds == TEdgeProps.EDeviceBounds.INDEVICE;
    }

    default int getMatchingDaysToLive(ru.yandex.crypta.graph2.model.soup.proto.EdgeType edgeType) {
        return getEdgeTypeConfig(edgeType).getProps().getMatchingDaysToLive();
    }

    private double getBaseWeight(TEdgeProps props) {
        TEdgeProps.EActivityType activityType = props.getActivityType();
        TEdgeProps.EEdgeStrength edgeStrength = props.getEdgeStrength();
        if (edgeStrength == TEdgeProps.EEdgeStrength.SUSPICIOUS) {
            return 0.05;
        } else if (activityType == TEdgeProps.EActivityType.NONE &&
                edgeStrength != TEdgeProps.EEdgeStrength.ARTIFICIAL &&
                edgeStrength != TEdgeProps.EEdgeStrength.PROBABILISTIC) {
            return 0;
        } else {
            return 1.0;
        }
    }

}
