package ru.yandex.crypta.graph2.model.soup.vertex.weight;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.crypta.graph2.model.soup.edge.weight.EdgeInfoProvider;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;

public class VerticesWeightsProvider implements YtSerializable {

    private MapF<Vertex, Double> verticesWeights;
    private EdgeInfoProvider edgeInfoProvider;

    public VerticesWeightsProvider(EdgeInfoProvider edgeInfoProvider,
                                   CollectionF<Edge> edges, CollectionF<Vertex> vertices) {
        this.edgeInfoProvider = edgeInfoProvider;
        this.verticesWeights = calculateVerticesWeights(edges, vertices);
    }

    private MapF<Vertex, Double> calculateVerticesWeights(CollectionF<Edge> edges, CollectionF<Vertex> vertices) {
        MapF<Vertex, Double> vertices2Weights = Cf.toHashMap(vertices.map(v -> Tuple2.tuple(v, 0.0d)));
        for (Edge edge : edges) {
            double edgeWeight = edgeInfoProvider.getEdgeWeight(edge);

            Vertex v1 = edge.getVertex1();
            Double v1Weight = vertices2Weights.getOrElse(v1, 0.0);
            vertices2Weights.put(v1, v1Weight + edgeWeight);

            Vertex v2 = edge.getVertex2();
            Double v2Weight = vertices2Weights.getOrElse(v2, 0.0);
            vertices2Weights.put(v2, v2Weight + edgeWeight);
        }

        return vertices2Weights;

    }

    public MapF<Vertex, Double> getVerticesWeights() {
        return verticesWeights;
    }

    public double getVertexWeight(Vertex vertex) {
        return verticesWeights.getTs(vertex);
    }
}
