#pragma once

#include <crypta/lib/python/native_yt/cpp/registrar.h>
#include <crypta/lib/python/native_yt/cpp/proto.h>
#include <crypta/graph/soup/orgs/proto/states.pb.h>
#include <util/generic/vector.h>
#include <util/stream/str.h>

#include <iterator>
#include <ctime>

#include <crypta/lib/nirvana/email_organization/vectorize/vectorize_email.h>

using NYT::IMapper;
using NYT::IReducer;
using NYT::TNode;
using NYT::TTableReader;
using NYT::TTableWriter;

namespace NEmailOrgModelApply {
    class TUniqueEmails: public IReducer<TTableReader<TNode>, TTableWriter<TNode>> {
    public:
        void Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) override;
    };

    class TTFModelApply: public IMapper<TTableReader<TNode>, TTableWriter<TNode>> {
    public:
        TTFModelApply();
        explicit TTFModelApply(const TBuffer& buffer);
        void Save(IOutputStream& output) const override;
        void Load(IInputStream& input) override;
        void Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) override;

    private:
        struct TSelf;
        THolder<TSelf> Self;
    };
}
