package ru.yandex.crypta.graph2.soup.config;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class ConfigParser {

    private static Option<YPath> optionalYPath(String path) {
        return Option.ofNullable(path).map(YPath::simple);
    }

    public static SoupAndStorageProcessingParams parse(PrepareSoupConfig config) {
        if (config.getSoupDir() != null && config.getSoupTable() != null) {
            throw new IllegalStateException("soupDir and soupTable params can't be set together");
        }

        if (config.getIdsStorageDir() != null && config.getIdsStorageTable() != null) {
            throw new IllegalStateException("idsStorageDir and idsStorageTables params can't be set together");
        }

        if (config.getSocdemStorageDir() != null && config.getSocdemStorageTable() != null) {
            throw new IllegalStateException("socdemStorageDir and socdemStorageTables params can't be set together");
        }

        return new SoupAndStorageProcessingParams(
                optionalYPath(config.getSoupDir()),
                optionalYPath(config.getSoupTable()),
                optionalYPath(config.getIdsStorageDir()),
                optionalYPath(config.getIdsStorageTable()),
                optionalYPath(config.getSharedStorageDir()),
                optionalYPath(config.getSharedStorageTable()),
                optionalYPath(config.getSocdemStorageDir()),
                optionalYPath(config.getSocdemStorageTable()),
                optionalYPath(config.getProbSocdemTable()),
                optionalYPath(config.getSoupSurvivalModelTable()),
                optionalYPath(config.getSoupStatsTable()),
                optionalYPath(config.getOutliersStorageDir()),
                YPath.simple(config.getOutputDir())
        );

    }
}
