package ru.yandex.crypta.graph2.soup.config;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.lang.DefaultToString;

public class SoupAndStorageProcessingParams extends DefaultToString {
    private final Option<YPath> soupDir;
    private final Option<YPath> soupTable;

    private final Option<YPath> idsStorageDir;
    private final Option<YPath> idsStorageTable;

    private final Option<YPath> sharedStorageDir;
    private final Option<YPath> sharedStorageTable;

    private final Option<YPath> socdemStorageDir;
    private final Option<YPath> socdemStorageTable;
    private final Option<YPath> probSocdemTable;
    private final Option<YPath> soupSurvivalModelTable;
    private final Option<YPath> soupStatsTable;

    private final Option<YPath> outliersStorageDir;

    private YPath outputDir;

    public SoupAndStorageProcessingParams(Option<YPath> soupDir, Option<YPath> soupTable,
                                          Option<YPath> idsStorageDir, Option<YPath> idsStorageTable,
                                          Option<YPath> sharedStorageDir, Option<YPath> sharedStorageTable,
                                          Option<YPath> socdemStorageDir, Option<YPath> socdemStorageTable,
                                          Option<YPath> probSocdemTable,
                                          Option<YPath> soupSurvivalModelTable, Option<YPath> soupStatsTable,
                                          Option<YPath> outliersStorageDir, YPath outputDir) {
        this.soupDir = soupDir;
        this.soupTable = soupTable;
        this.idsStorageDir = idsStorageDir;
        this.idsStorageTable = idsStorageTable;
        this.sharedStorageDir = sharedStorageDir;
        this.sharedStorageTable = sharedStorageTable;
        this.socdemStorageDir = socdemStorageDir;
        this.socdemStorageTable = socdemStorageTable;
        this.probSocdemTable = probSocdemTable;
        this.soupSurvivalModelTable = soupSurvivalModelTable;
        this.soupStatsTable = soupStatsTable;
        this.outputDir = outputDir;
        this.outliersStorageDir = outliersStorageDir;
    }

    public Option<YPath> getSoupDir() {
        return soupDir;
    }

    public Option<YPath> getSoupTable() {
        return soupTable;
    }

    public Option<YPath> getIdsStorageDir() { return idsStorageDir; }

    public Option<YPath> getIdsStorageTable() {
        return idsStorageTable;
    }

    public Option<YPath> getSharedStorageDir() { return sharedStorageDir; }

    public Option<YPath> getSharedStorageTable() {
        return sharedStorageTable;
    }

    public Option<YPath> getOutliersStorageDir() {
        return outliersStorageDir;
    }

    public Option<YPath> getSocdemStorageDir() {
        return socdemStorageDir;
    }

    public Option<YPath> getSocdemStorageTable() {
        return socdemStorageTable;
    }

    public Option<YPath> getProbSocdemTable() {
        return probSocdemTable;
    }

    public Option<YPath> getSoupSurvivalModelTable() {
        return soupSurvivalModelTable;
    }

    public Option<YPath> getSoupStatsTable() {
        return soupStatsTable;
    }

    public YPath getOutputDir() {
        return outputDir;
    }

}
