package ru.yandex.crypta.graph2.soup.workflow;

import java.util.stream.Stream;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeProps;
import ru.yandex.crypta.graph2.dao.Dao;
import ru.yandex.crypta.graph2.dao.yt.bendable.YsonMultiEntitySupport;
import ru.yandex.crypta.graph2.dao.yt.schema.extractor.YTreeYtSchemaExtractor;
import ru.yandex.crypta.graph2.model.soup.edge.EdgeType;
import ru.yandex.crypta.graph2.model.soup.sources.DefaultEdgeTypeConfigProvider;
import ru.yandex.crypta.graph2.model.soup.sources.EdgeTypeConfigProvider;
import ru.yandex.crypta.graph2.soup.config.SoupAndStorageProcessingParams;
import ru.yandex.crypta.graph2.soup.workflow.model.EdgeTypeConfig;
import ru.yandex.crypta.graph2.workflow.EmptyInput;
import ru.yandex.crypta.graph2.workflow.Task;
import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;
import ru.yandex.yt.ytclient.tables.ColumnSchema;
import ru.yandex.yt.ytclient.tables.ColumnValueType;
import ru.yandex.yt.ytclient.tables.TableSchema;

public class DumpSoupConfigTask extends Task<EmptyInput, YPath, SoupAndStorageProcessingParams> {

    private final YPath output;

    private final YTreeYtSchemaExtractor schemaExtractor = new YTreeYtSchemaExtractor();
    private final YsonMultiEntitySupport serializer = new YsonMultiEntitySupport();

    public DumpSoupConfigTask(Dao dao, YPath workdir, SoupAndStorageProcessingParams params) {
        super(dao, workdir, params);

        this.output = workdir.child("edge_types");
    }

    @Override
    protected void runImpl(EmptyInput emptyInput) {

        TableSchema schema = schemaExtractor.extractUnionTableSchema(Cf.list(
                EdgeType.class,
                EdgeTypeConfig.class
        )).toBuilder()
                .add(new ColumnSchema("path", ColumnValueType.STRING))
                .build();

        YPath outTable = dao.ytCypress().createTableWithSchema(output, schema);

        EdgeTypeConfigProvider edgeTypeConfigProvider = new DefaultEdgeTypeConfigProvider();

        dao.ytTr().withTransaction(transaction -> {
            Option<GUID> trId = Option.of(transaction.getId());
            dao.yt().tables().write(trId.toOptional(), false,
                    outTable,
                    YTableEntryTypes.YSON,
                    Cf.wrap(dumpEdges(edgeTypeConfigProvider).iterator())
            );

            dao.ytOps().sortSync(trId, outTable, EdgeType.EDGE_TYPE_UNIQUE_KEY);
        });

    }

    private Stream<YTreeMapNode> dumpEdges(EdgeTypeConfigProvider edgeTypeConfigProvider) {
        return Soup.CONFIG.getEdgeTypes().stream().map(tEdgeType -> {
            EdgeType edgeType = new EdgeType(
                    tEdgeType.getId1Type(),
                    tEdgeType.getId2Type(),
                    tEdgeType.getSourceType(),
                    tEdgeType.getLogSource()
            );

            TEdgeProps.EEdgeStrength edgeStrength = edgeTypeConfigProvider
                    .getEdgeTypeConfig(edgeType)
                    .getProps()
                    .getEdgeStrength();

            EdgeTypeConfig etc = new EdgeTypeConfig(
                    edgeTypeConfigProvider.getBaseWeight(edgeType),
                    edgeStrength,
                    edgeTypeConfigProvider.hasActivity(edgeType),
                    edgeTypeConfigProvider.isIndevice(edgeType)
            );

            YTreeMapNode edgeTypeRec = serializer.serialize(edgeType);
            YTreeMapNode edgeTypeConfigRec = serializer.serialize(etc);

            for (String col : edgeTypeConfigRec.keys()) {
                edgeTypeRec.put(col, edgeTypeConfigRec.getOrThrow(col));

                if (params.getSoupDir().isPresent()) {
                    String soupTablePath = params.getSoupDir().get().child(edgeType.getTableName()).toString();
                    edgeTypeRec.put("path", YTree.stringNode(soupTablePath));
                }

            }

            return edgeTypeRec;
        });
    }

    @Override
    public YPath getOutput() {
        return output;
    }

    @Override
    public String getDescription() {
        return "Dumps soup configuration to YT table";
    }
}
