package ru.yandex.crypta.graph2.soup.workflow.model;


import ru.yandex.crypta.graph.soup.config.proto.TEdgeProps;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

@YTreeObject
public class EdgeTypeConfig {

    @YTreeField
    private double baseWeight;
    @YTreeField
    private TEdgeProps.EEdgeStrength edgeTypeStrength;
    /**
     * false if no activity can be tracked for this type of edge
     */
    @YTreeField
    private boolean hasActivity;
    @YTreeField
    private boolean isIndevice;

    public EdgeTypeConfig(double baseWeight, TEdgeProps.EEdgeStrength edgeTypeStrength, boolean hasActivity,
                          boolean isIndevice) {
        this.baseWeight = baseWeight;
        this.edgeTypeStrength = edgeTypeStrength;
        this.hasActivity = hasActivity;
        this.isIndevice = isIndevice;
    }

    public TEdgeProps.EEdgeStrength getEdgeTypeStrength() {
        return edgeTypeStrength;
    }

    public boolean hasActivity() {
        return hasActivity;
    }

    public double getBaseWeight() {
        return baseWeight;
    }

    public boolean isIndevice() {
        return isIndevice;
    }
}
