package ru.yandex.crypta.graph2.soup.workflow.ops;

import ru.yandex.crypta.graph2.model.matching.proto.CryptaIdEdgeMessage;
import ru.yandex.crypta.graph2.model.soup.proto.Edge;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.operations.map.Mapper;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;

public class CreateBlankMessagesFromEdges implements Mapper<Edge, CryptaIdEdgeMessage>, YtSerializable {

    @Override
    public void map(Edge edge, Yield<CryptaIdEdgeMessage> yield, Statistics statistics) {

        CryptaIdEdgeMessage.Builder edgeBuilder = CryptaIdEdgeMessage.newBuilder()
                .setId1(edge.getId1())
                .setId1Type(edge.getId1Type())
                .setId2(edge.getId2())
                .setId2Type(edge.getId2Type())
                .setSourceType(edge.getSourceType())
                .setLogSource(edge.getLogSource())
                .setDatesWeight(edge.getDatesWeight())
                .setSurvivalWeight(edge.getSurvivalWeight())
                .setIndevice(edge.getIndevice());

        CryptaIdEdgeMessage directMessage = edgeBuilder
                .setId(edge.getId2())
                .setIdType(edge.getId2Type())
                .setReversed(false)
                .build();

        CryptaIdEdgeMessage reversedEdge = edgeBuilder
                .setId(edge.getId1())
                .setIdType(edge.getId1Type())
                .setReversed(true)
                .build();

        yield.yield(directMessage);
        yield.yield(reversedEdge);
    }

    @Override
    public YTableEntryType<Edge> inputType() {
        return YTableEntryTypes.nativeProto(Edge.class);
    }

    @Override
    public YTableEntryType<CryptaIdEdgeMessage> outputType() {
        return YTableEntryTypes.nativeProto(CryptaIdEdgeMessage.class);
    }
}
