package ru.yandex.crypta.graph2.soup.workflow.ops;

import java.util.List;
import java.util.Optional;

import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph2.dao.yt.bendable.YsonMultiEntitySupport;
import ru.yandex.crypta.graph2.dao.yt.utils.YTreeUtils;
import ru.yandex.crypta.graph2.model.soup.props.HasActivity;
import ru.yandex.crypta.graph2.model.soup.props.VertexProperties;
import ru.yandex.crypta.graph2.model.soup.props.Yandexuid;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.crypta.lib.proto.identifiers.TIdType;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.operations.map.Mapper;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

public class ImportIdStorageVerticesProperties extends YsonMultiEntitySupport implements Mapper<YTreeMapNode,
        YTreeMapNode>, YtSerializable {

    private static final String GENDER_COLUMN = "gender";
    private static final int YANDEXUID_UA_COUNT_THRESHOLD = 10000;

    @Override
    public void map(YTreeMapNode rec, Yield<YTreeMapNode> yield, Statistics statistics) {
        resetTableIndex(rec);

        Optional<String> maybeId = rec.getStringO(Vertex.ID_COLUMN);
        TIdType maybeIdType = Soup.CONFIG.getIdType(rec.getString(Vertex.ID_TYPE_COLUMN));

        // Throw out yandexuids that have too many different useragents
        Optional<YTreeNode> maybeUas = rec.get("multi_user_agent");
        if (maybeUas.isPresent()) {
            YTreeNode ytn = maybeUas.get();
            if (ytn.isListNode() && ytn.asList().size() > YANDEXUID_UA_COUNT_THRESHOLD) {
                return;
            }
        }

        if (maybeId.isPresent() && maybeIdType != null){
            rec.put(Vertex.ID_TYPE_COLUMN, YTree.stringNode(maybeIdType.getName()));
            if (!rec.containsKey(VertexProperties.SOURCE_COLUMN)) {
                rec.put(VertexProperties.SOURCE_COLUMN, YTree.stringNode(Yandexuid.YUID_WITH_ALL_SOURCE));
            }
            // Column is removed as it has the same name with the column from socdem (ExactSocdem.Gender) and this
            // specific column is not not used anywhere in code. This removal prevents this column from the future
            // conflicts with the column from socdem.
            rec.remove(GENDER_COLUMN);

            Optional<YTreeNode> maybeDatesColumn = YTreeUtils.getNullableNode(rec, VertexProperties.DATES_COLUMN);
            if (maybeDatesColumn.isPresent()) {
                List<YTreeNode> dates = maybeDatesColumn.get().asList();
                boolean isActive = !dates.isEmpty();

                // replace heavy dates column with light boolean column for performance
                rec.put(HasActivity.IS_ACTIVE_COLUMN, YTree.booleanNode(isActive));
//                rec.remove(VertexProperties.DATES_COLUMN);
            }

            yield.yield(rec);
        }
    }
}
