package ru.yandex.crypta.graph2.soup.workflow.ops;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph2.dao.yt.bendable.YsonMultiEntitySupport;
import ru.yandex.crypta.graph2.model.soup.props.CommonShared;
import ru.yandex.crypta.graph2.model.soup.props.VertexProperties;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.crypta.lib.proto.identifiers.TIdType;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.operations.map.Mapper;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

public class ImportSharedStorageVerticesProperties extends YsonMultiEntitySupport implements Mapper<YTreeMapNode,
        YTreeMapNode>, YtSerializable {

    private static final String SHARED_HEURISTIC_COLUMN = "shared_types";
    private static final String HEURISTIC_SHARED_DESKTOP_SOURCE = "HEURISTIC_DESKTOP";

    @Override
    public void map(YTreeMapNode rec, Yield<YTreeMapNode> yield, Statistics statistics) {
        resetTableIndex(rec);

        TIdType checkedIdType = Soup.CONFIG
                .getIdType(rec.getString(Vertex.ID_TYPE_COLUMN));

        List<String> sharedHeuristics = rec.getOrThrow(SHARED_HEURISTIC_COLUMN)
                .listNode()
                .asList()
                .stream()
                .map(YTreeNode::stringValue)
                .collect(Collectors.toList());
        if (sharedHeuristics.size() == 1 && sharedHeuristics.get(0).equals(HEURISTIC_SHARED_DESKTOP_SOURCE)) {
            // CRYPTAPRIVATE-59
            return;
        }

        rec.put(Vertex.ID_TYPE_COLUMN, YTree.stringNode(checkedIdType.getName()));
        rec.put(VertexProperties.SOURCE_COLUMN, YTree.stringNode(CommonShared.COMMON_SHARED_SOURCE));

        yield.yield(rec);

    }
}
