package ru.yandex.crypta.graph2.soup.workflow.ops;

import java.util.Optional;

import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph2.dao.yt.bendable.YsonMultiEntitySupport;
import ru.yandex.crypta.graph2.dao.yt.utils.YTreeUtils;
import ru.yandex.crypta.graph2.model.soup.props.VertexExactSocdem;
import ru.yandex.crypta.graph2.model.soup.props.VertexProperties;
import ru.yandex.crypta.graph2.model.soup.props.info.ExactSocdem.Gender;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.crypta.lib.proto.identifiers.TIdType;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.operations.map.Mapper;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

public class ImportSocdemStorageVerticesProperties extends YsonMultiEntitySupport implements Mapper<YTreeMapNode, YTreeMapNode>, YtSerializable {


    public Option<Gender> fixGender(YTreeMapNode rec) {
        return Option.wrap(YTreeUtils.getNullableNode(rec, VertexExactSocdem.GENDER_COLUMN))
                .map(YTreeNode::stringValue)
                .flatMapO(Gender.COMPATIBILITY_MAP::getO);
    }

    @Override
    public void map(YTreeMapNode rec, Yield<YTreeMapNode> yield, Statistics statistics) {
        resetTableIndex(rec);

        Optional<String> maybeId = rec.getStringO(Vertex.ID_COLUMN);
        Optional<TIdType> maybeIdType = rec
                .getStringO(Vertex.ID_TYPE_COLUMN)
                .flatMap(v -> Optional.ofNullable(Soup.CONFIG.getIdType(v)));

        YTreeNode socdemSource = YTree.stringNode(rec.getString("source"));

        if (maybeId.isPresent() && maybeIdType.isPresent()) {
            rec.put(Vertex.ID_TYPE_COLUMN, YTree.stringNode(maybeIdType.get().getName()));
            rec.put(VertexProperties.SOURCE_COLUMN, YTree.stringNode(VertexExactSocdem.EXACT_SOCDEM_SOURCE));
            rec.put(VertexExactSocdem.SOCDEM_SOURCE_COLUMN, socdemSource);

            Option<Gender> maybeFixedGender = fixGender(rec);
            if (maybeFixedGender.isPresent()) {
                rec.put(VertexExactSocdem.GENDER_COLUMN, YTree.stringNode(maybeFixedGender.get().value()));
                yield.yield(rec);
            }

        }

    }
}
