package ru.yandex.crypta.graph2.soup.workflow.ops.helper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.crypta.graph2.model.soup.props.VertexSocdemProbSegments;
import ru.yandex.crypta.graph2.model.soup.props.info.ProbSocdem;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;
import ru.yandex.misc.lang.number.UnsignedLong;

@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class ProfileProbSocdem {
    public static final String SOURCE = "prob_socdem";
    public static final String GENDER = "gender";

    @YTreeField(key = GENDER)
    private MapF<String, Double> genderSegments;

    @YTreeField
    private UnsignedLong yandexuid;

    public VertexSocdemProbSegments convertToVertexSocdemProbSegments() {
        return new VertexSocdemProbSegments(
                new Vertex(String.valueOf(yandexuid), EIdType.YANDEXUID),
                new ProbSocdem(genderSegments, Cf.map()),
                SOURCE
        );
    }

}
