package ru.yandex.crypta.graph2.soup.dynamic;

import java.time.LocalDate;

import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.crypta.graph2.dao.Dao;
import ru.yandex.crypta.graph2.dao.yql.Yql;
import ru.yandex.crypta.graph2.dao.yql.YqlConfig;
import ru.yandex.crypta.graph2.dao.yt.YtConfig;
import ru.yandex.crypta.graph2.dao.yt.ops.YtOpsParams;
import ru.yandex.crypta.graph2.soup.dynamic.config.ConfigParser;
import ru.yandex.crypta.graph2.soup.dynamic.config.PrepareSoupDynamicConfig;
import ru.yandex.crypta.graph2.soup.dynamic.config.SoupDynamicProcessingParams;
import ru.yandex.crypta.graph2.soup.dynamic.workflow.PrepareSoupDynamicWorkflow;
import ru.yandex.crypta.graph2.soup.dynamic.workflow.PrepareSoupDynamicWorkflow.DynamicProcessingDates;
import ru.yandex.crypta.graph2.utils.NativeLibHelper;
import ru.yandex.crypta.graph2.utils.YamlConfig;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class PrepareSoupDynamicMain {
    private static final Logger LOG = LoggerFactory.getLogger(PrepareSoupDynamicMain.class);

    public static void main(String[] args) {

        OptionParser parser = new OptionParser();
        OptionSpec<String> configArg = parser
                .accepts("config")
                .withRequiredArg()
                .defaultsTo("config.yaml");

        parser.allowsUnrecognizedOptions();
        OptionSet options = parser.parse(args);

        NativeLibHelper.setLocalJavaLibraryPath();

        Yt yt = YtConfig.getYt(true);
        Yql yql = YqlConfig.getYql();
        YtOpsParams ytOpsParams = new YtOpsParams();

        Dao dao = new Dao(yt, yql, ytOpsParams);

        String configFile = options.valueOf(configArg);
        PrepareSoupDynamicConfig config = YamlConfig.readConfigFromFile(configFile, PrepareSoupDynamicConfig.class);
        LOG.info("PrepareSoupConfig:\n{}", config);

        SoupDynamicProcessingParams params = ConfigParser.parse(config);
        LOG.info("SoupDynamicProcessingParams:\n{}", params);

        PrepareSoupDynamicWorkflow prepareSoupWorkflow = new PrepareSoupDynamicWorkflow(dao, params);
        DynamicProcessingDates inTables = getSoupDynamicGenerateDates(dao, config);

        prepareSoupWorkflow.run(inTables);
    }

    private static DynamicProcessingDates getSoupDynamicGenerateDates(Dao dao, PrepareSoupDynamicConfig config) {
        LocalDate startDate = LocalDate.now();

        LocalDate soupGenerateDate = dao.ytCypress().getGenerationDate(
                YPath.simple(config.getSoupDir())
        ).getOrElse(startDate);

        LOG.info("soupGenerateDate: " + soupGenerateDate);
        return new DynamicProcessingDates(soupGenerateDate);
    }
}
