package ru.yandex.crypta.graph2.soup.dynamic.config;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class ConfigParser {

    private static Option<YPath> optionalYPath(String path) {
        return Option.ofNullable(path).map(YPath::simple);
    }

    public static SoupDynamicProcessingParams parse(PrepareSoupDynamicConfig config) {
        if (config.getSoupDir() != null && config.getSoupTable() != null) {
            throw new IllegalStateException("soupDir and soupTable params can't be set together");
        }

        return new SoupDynamicProcessingParams(
                optionalYPath(config.getSoupDir()),
                optionalYPath(config.getSoupTable()),
                optionalYPath(config.getIdsStorageDir()),
                optionalYPath(config.getIdsStorageTable()),
                optionalYPath(config.getSoupStatsTable()),
                YPath.simple(config.getOutputDir())
        );

    }
}
