package ru.yandex.crypta.graph2.soup.dynamic.config;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.lang.DefaultToString;

public class SoupDynamicProcessingParams extends DefaultToString {
    private final Option<YPath> soupDir;
    private final Option<YPath> soupTable;

    private final Option<YPath> idsStorageDir;
    private final Option<YPath> idsStorageTable;

    private final Option<YPath> soupStatsTable;

    private YPath outputDir;

    public SoupDynamicProcessingParams(Option<YPath> soupDir, Option<YPath> soupTable, Option<YPath> idsStorageDir,
                                       Option<YPath> idsStorageTable, Option<YPath> soupStatsTable, YPath outputDir) {
        this.soupDir = soupDir;
        this.soupTable = soupTable;
        this.idsStorageDir = idsStorageDir;
        this.idsStorageTable = idsStorageTable;
        this.soupStatsTable = soupStatsTable;
        this.outputDir = outputDir;
    }

    public Option<YPath> getSoupDir() {
        return soupDir;
    }

    public Option<YPath> getSoupTable() {
        return soupTable;
    }

    public Option<YPath> getIdsStorageDir() { return idsStorageDir; }

    public Option<YPath> getIdsStorageTable() {
        return idsStorageTable;
    }

    public Option<YPath> getSoupStatsTable() {
        return soupStatsTable;
    }

    public YPath getOutputDir() {
        return outputDir;
    }

}
