package ru.yandex.crypta.graph2.soup.dynamic.workflow;

import java.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph2.dao.Dao;
import ru.yandex.crypta.graph2.soup.dynamic.config.SoupDynamicProcessingParams;
import ru.yandex.crypta.graph2.soup.dynamic.workflow.PrepareSoupDynamicWorkflow.DynamicProcessingDates;
import ru.yandex.crypta.graph2.workflow.EmptyInput;
import ru.yandex.crypta.graph2.workflow.Task;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class PrepareSoupDynamicWorkflow extends Task<DynamicProcessingDates, ListF<YPath>, SoupDynamicProcessingParams> {
    private final PrepareSoupEdgesBackwardsTask prepareSoupEdgesBackwardsTask;
    private final PrepareVerticesPropertiesDynamicTask prepareVerticesPropertiesDynamicTask;

    public PrepareSoupDynamicWorkflow(Dao dao, SoupDynamicProcessingParams params) {
        super(dao, params.getOutputDir(), params);

        this.prepareSoupEdgesBackwardsTask = new PrepareSoupEdgesBackwardsTask(
                dao, workdir, params
        );

        this.prepareVerticesPropertiesDynamicTask = new PrepareVerticesPropertiesDynamicTask(
                dao, workdir, params
        );
    }

    @Override
    protected void runImpl(PrepareSoupDynamicWorkflow.DynamicProcessingDates originalDataDates) {

        // TODO: add vertices processing task

        prepareSoupEdgesBackwardsTask.run(EmptyInput.INSTANCE);
        prepareVerticesPropertiesDynamicTask.run(EmptyInput.INSTANCE);

        LocalDate endOfProcessingDate = LocalDate.now();

        getOutput().forEach(t -> {
            dao.ytCypress().setRunDate(t, endOfProcessingDate);
            dao.ytCypress().setGenerationDate(t, originalDataDates.soupDynamicGenerateDate);
        });
    }

    @Override
    public ListF<YPath> getOutput() {
        return Cf.list(
                prepareSoupEdgesBackwardsTask.getOutput()
        );
    }

    @Override
    public String getDescription() {
        return "Prepares dynamic soup edges and vertices properties tables";
    }

    public static class DynamicProcessingDates {
        final LocalDate soupDynamicGenerateDate;

        public DynamicProcessingDates(LocalDate soupDynamicGenerateDate) {
            this.soupDynamicGenerateDate = soupDynamicGenerateDate;
        }
    }
}
