package ru.yandex.crypta.graph2.soup.dynamic.workflow.ops;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.inside.yt.kosher.impl.operations.utils.YtSerializable;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.operations.map.Mapper;

public class PrepareSoupEdgesBackwards implements Mapper<Edge, Edge>, YtSerializable {

    @Override
    public void map(Edge edge, Yield<Edge> yield, Statistics statistics) {
        // don't put dates to dynamic edges
        Edge directEdge = new Edge(
                edge.getId1(), edge.getId1Type(), edge.getId2(), edge.getId2Type(), edge.getSourceType(),
                edge.getLogSource(), Cf.list(), edge.getDatesWeight(), edge.getSurvivalWeight()
        );

        // don't put dates to dynamic edges
        Edge reversedEdge = new Edge(
                edge.getId2(), edge.getId2Type(), edge.getId1(), edge.getId1Type(), edge.getSourceType(),
                edge.getLogSource(), Cf.list(), edge.getDatesWeight(), edge.getSurvivalWeight()
        );

        yield.yield(0, directEdge);

        if (!reversedEdge.isLoop()) { // throw incorrect a -> a edges
            yield.yield(0, reversedEdge);
        }
    }
}
