-- CRYPTA-9337

$soup = '{{ input_soup }}';
$output_exp_soup = '{{ output_exp_soup }}';

/* Keyboard Exp

PRAGMA TablePathPrefix = "//home/crypta/production/state/graph/v2/soup";

$kb_uuids = (
    SELECT id
    FROM `//home/crypta/public/ids_storage/uuid/eternal`
    WHERE False
        -- android
        OR Yson::Contains(api_keys, "3295618")
        OR (Yson::Contains(api_keys, "112684") AND app_id == "ru.yandex.androidkeyboard")
        -- ios
        OR Yson::Contains(api_keys, "38000")
        OR Yson::Contains(api_keys, "3846355")
);

DEFINE SUBQUERY $filtered_cookie_edges($id_type) AS
    SELECT *
    FROM CONCAT(
        $id_type || "_uuid_app-metrica-socket-ios_wl",
        $id_type || "_uuid_app-metrica-socket-android_wl"
    ) AS edge
    LEFT SEMI JOIN $kb_uuids AS id
    ON (edge.id2 == id.id)
END DEFINE;

DEFINE SUBQUERY $filter_device_edges($id_type) AS
    SELECT *
    FROM CONCAT(
        $id_type || "_idfa_app-metrica-socket-ios_wl",
        $id_type || "_gaid_app-metrica-socket-android_wl",
        $id_type || "_oaid_app-metrica-socket-android_wl"
    ) AS edge
    LEFT SEMI JOIN (
        SELECT DISTINCT id1
        FROM $filtered_cookie_edges($id_type)
    ) AS cookie
    USING (id1)
END DEFINE;

$socket_id_types = ["duid", "yandexuid"];
$cookies = SubqueryExtendFor($socket_id_types, $filtered_cookie_edges);
$devices = SubqueryExtendFor($socket_id_types, $filter_device_edges);

$all_filtered_edges = (
    PROCESS $cookies()
    UNION ALL
    PROCESS $devices()
);

$exp_soup = (
  SELECT *
  FROM $soup AS soup
  LEFT ONLY JOIN $all_filtered_edges AS filter_edges
  USING (id1, id2, id1Type, id2Type, logSource, sourceType)
);

/* Fresh Sklejka EXP

$min_active_date = EvaluateExpr(
    DateTime::Format("%Y-%m-%d")(
        CurrentUtcTimestamp() - Interval("P370D")
    )
);

$exp_soup = (
    SELECT *
    FROM $soup
    WITH COLUMNS Struct<dates:List<String>?>
    WHERE (id1Type != "mac" AND id2Type != "mac")
    AND (
        ListLength(dates) == 0 -- not daily active edge
        OR ListMax(dates) > $min_active_date  -- has activity last year
    )
);
*/

/* NO MAC Addr Sklejka EXP */

$exp_soup = (
    SELECT *
    FROM $soup
    WITH COLUMNS Struct<dates:List<String>?>
    WHERE (id1Type != "mac" AND id2Type != "mac")
);

INSERT INTO $output_exp_soup WITH TRUNCATE
SELECT *
FROM $exp_soup
ORDER BY id1Type, id2Type, sourceType, logSource, id1, id2;
